package com.facebook.presto.hadoop.$internal.org.codehaus.jackson.map.ser.std;

import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Date;

import com.facebook.presto.hadoop.$internal.org.codehaus.jackson.JsonGenerationException;
import com.facebook.presto.hadoop.$internal.org.codehaus.jackson.JsonGenerator;
import com.facebook.presto.hadoop.$internal.org.codehaus.jackson.JsonNode;
import com.facebook.presto.hadoop.$internal.org.codehaus.jackson.map.SerializationConfig;
import com.facebook.presto.hadoop.$internal.org.codehaus.jackson.map.SerializerProvider;
import com.facebook.presto.hadoop.$internal.org.codehaus.jackson.map.annotate.JacksonStdImpl;

/**
 * For efficiency, we will serialize Dates as longs, instead of
 * potentially more readable Strings.
 *<p>
 * @since 1.9 (moved from 'com.facebook.presto.hadoop.$internal.org.codehaus.jackson.map.ser.StdSerializers#UtilDateSerializer}
 */
@JacksonStdImpl
public class DateSerializer
    extends ScalarSerializerBase<java.util.Date>
{
    public static DateSerializer instance = new DateSerializer();
    
    public DateSerializer() { super(Date.class); }

    @Override
    public void serialize(Date value, JsonGenerator jgen, SerializerProvider provider)
        throws IOException, JsonGenerationException
    {
        provider.defaultSerializeDateValue(value, jgen);
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint)
    {
        //todo: (ryan) add a format for the date in the schema?
        return createSchemaNode(provider.isEnabled(SerializationConfig.Feature.WRITE_DATES_AS_TIMESTAMPS)
                ? "number" : "string", true);
    }
}
