/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.common;

import com.facebook.presto.common.RuntimeMetric;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class RuntimeStats {
    private final Map<String, RuntimeMetric> metrics;

    public RuntimeStats() {
        this.metrics = new HashMap<String, RuntimeMetric>();
    }

    @JsonCreator
    public RuntimeStats(Map<String, RuntimeMetric> metrics) {
        this.metrics = Objects.requireNonNull(metrics, "metrics is null");
    }

    public static RuntimeStats copyOf(RuntimeStats stats) {
        Objects.requireNonNull(stats, "stats is null");
        RuntimeStats statsCopy = new RuntimeStats();
        statsCopy.mergeWith(stats);
        return statsCopy;
    }

    public static RuntimeStats merge(RuntimeStats stats1, RuntimeStats stats2) {
        if (stats1 == null) {
            return stats2;
        }
        if (stats2 == null) {
            return stats1;
        }
        RuntimeStats mergedStats = RuntimeStats.copyOf(stats1);
        mergedStats.mergeWith(stats2);
        return mergedStats;
    }

    public void reset() {
        this.metrics.clear();
    }

    public RuntimeMetric getMetric(String name) {
        return this.metrics.get(name);
    }

    @JsonValue
    public Map<String, RuntimeMetric> getMetrics() {
        return this.metrics;
    }

    public void addMetricValue(String name, long value) {
        this.metrics.computeIfAbsent(name, RuntimeMetric::new);
        this.metrics.get(name).addValue(value);
    }

    public void mergeWith(RuntimeStats stats) {
        if (stats == null) {
            return;
        }
        stats.getMetrics().values().forEach(metric -> {
            this.metrics.computeIfAbsent(metric.getName(), RuntimeMetric::new);
            this.metrics.get(metric.getName()).mergeWith((RuntimeMetric)metric);
        });
    }

    public void update(RuntimeStats stats) {
        if (stats == null) {
            return;
        }
        stats.getMetrics().values().forEach(metric -> this.metrics.put(metric.getName(), RuntimeMetric.copyOf(metric)));
    }
}

