/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject.statement.internal;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.generic.GenericTypes;
import org.jdbi.v3.core.statement.Call;
import org.jdbi.v3.core.statement.OutParameters;
import org.jdbi.v3.sqlobject.statement.internal.CustomizingStatementHandler;
import org.jdbi.v3.sqlobject.statement.internal.SqlObjectStatementConfiguration;

public class SqlCallHandler
extends CustomizingStatementHandler<Call> {
    private final boolean returnOutParams;

    public SqlCallHandler(Class<?> sqlObjectType, Method method) {
        super(sqlObjectType, method);
        Type returnType = GenericTypes.resolveType((Type)method.getGenericReturnType(), sqlObjectType);
        Class returnClass = GenericTypes.getErasedType((Type)returnType);
        if (Void.TYPE.equals(returnClass)) {
            this.returnOutParams = false;
        } else if (OutParameters.class.isAssignableFrom(returnClass)) {
            this.returnOutParams = true;
        } else {
            throw new IllegalArgumentException("@SqlCall methods may only return null or OutParameters at present");
        }
    }

    @Override
    Call createStatement(Handle handle, String locatedSql) {
        return handle.createCall(locatedSql);
    }

    @Override
    void configureReturner(Call c, SqlObjectStatementConfiguration cfg) {
        cfg.setReturner(() -> {
            OutParameters ou = c.invoke();
            if (this.returnOutParams) {
                return ou;
            }
            return null;
        });
    }
}

