/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.bytecode;

import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

class AddFakeLineNumberClassVisitor
extends ClassVisitor {
    int methodCount;

    public AddFakeLineNumberClassVisitor(ClassVisitor cv) {
        super(327680, cv);
        super.visitSource("FakeSource.java", null);
    }

    public void visitSource(String source, String debug) {
        super.visitSource(source, debug);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor methodVisitor = this.cv.visitMethod(access, name, desc, signature, exceptions);
        ++this.methodCount;
        return new AddFakeLineNumberMethodVisitor(methodVisitor, 1000 * this.methodCount);
    }

    private static class AddFakeLineNumberMethodVisitor
    extends MethodVisitor {
        private int count;

        public AddFakeLineNumberMethodVisitor(MethodVisitor mv, int startLineNumber) {
            super(327680, mv);
            this.count = startLineNumber;
        }

        private void addFakeLineNumber() {
            Label label = new Label();
            this.mv.visitLabel(label);
            this.mv.visitLineNumber(++this.count, label);
        }

        public void visitInsn(int opcode) {
            this.addFakeLineNumber();
            super.visitInsn(opcode);
        }

        public void visitIntInsn(int opcode, int operand) {
            this.addFakeLineNumber();
            super.visitIntInsn(opcode, operand);
        }

        public void visitVarInsn(int opcode, int var) {
            this.addFakeLineNumber();
            super.visitVarInsn(opcode, var);
        }

        public void visitTypeInsn(int opcode, String type) {
            this.addFakeLineNumber();
            super.visitTypeInsn(opcode, type);
        }

        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            this.addFakeLineNumber();
            super.visitFieldInsn(opcode, owner, name, desc);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
            this.addFakeLineNumber();
            super.visitMethodInsn(opcode, owner, name, desc, itf);
        }

        public void visitInvokeDynamicInsn(String name, String desc, Handle bsm, Object ... bsmArgs) {
            this.addFakeLineNumber();
            super.visitInvokeDynamicInsn(name, desc, bsm, bsmArgs);
        }

        public void visitJumpInsn(int opcode, Label label) {
            this.addFakeLineNumber();
            super.visitJumpInsn(opcode, label);
        }

        public void visitLdcInsn(Object cst) {
            this.addFakeLineNumber();
            super.visitLdcInsn(cst);
        }

        public void visitIincInsn(int var, int increment) {
            this.addFakeLineNumber();
            super.visitIincInsn(var, increment);
        }

        public void visitTableSwitchInsn(int min, int max, Label dflt, Label ... labels) {
            this.addFakeLineNumber();
            super.visitTableSwitchInsn(min, max, dflt, labels);
        }

        public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
            this.addFakeLineNumber();
            super.visitLookupSwitchInsn(dflt, keys, labels);
        }

        public void visitMultiANewArrayInsn(String desc, int dims) {
            this.addFakeLineNumber();
            super.visitMultiANewArrayInsn(desc, dims);
        }
    }
}

