/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.bytecode.debug;

import com.facebook.airlift.bytecode.BytecodeNode;
import com.facebook.airlift.bytecode.BytecodeVisitor;
import com.facebook.airlift.bytecode.MethodGenerationContext;
import com.facebook.airlift.bytecode.Variable;
import com.facebook.airlift.bytecode.debug.DebugNode;
import com.facebook.airlift.bytecode.instruction.LabelNode;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.objectweb.asm.MethodVisitor;

public class LocalVariableNode
implements DebugNode {
    private final Variable variable;
    private final LabelNode start;
    private final LabelNode end;

    public LocalVariableNode(Variable variable, LabelNode start, LabelNode end) {
        this.variable = variable;
        this.start = start;
        this.end = end;
    }

    @Override
    public void accept(MethodVisitor visitor, MethodGenerationContext generationContext) {
        visitor.visitLocalVariable(this.variable.getName(), this.variable.getType().getType(), this.variable.getType().getGenericSignature(), this.start.getLabel(), this.end.getLabel(), generationContext.getVariableSlot(this.variable));
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("variable", (Object)this.variable).add("start", (Object)this.start).add("end", (Object)this.end).toString();
    }

    @Override
    public List<BytecodeNode> getChildNodes() {
        return ImmutableList.of();
    }

    @Override
    public <T> T accept(BytecodeNode parent, BytecodeVisitor<T> visitor) {
        return visitor.visitLocalVariable(parent, this);
    }
}

