/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drift.codec.internal.builtin;

import com.facebook.drift.codec.ThriftCodec;
import com.facebook.drift.codec.metadata.ThriftType;
import com.facebook.drift.protocol.TProtocolReader;
import com.facebook.drift.protocol.TProtocolWriter;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;

@Immutable
public class OptionalThriftCodec<T>
implements ThriftCodec<Optional<T>> {
    private final ThriftCodec<T> elementCodec;
    private final ThriftType type;

    public OptionalThriftCodec(ThriftType type, ThriftCodec<T> elementCodec) {
        this.type = Objects.requireNonNull(type, "type is null");
        this.elementCodec = Objects.requireNonNull(elementCodec, "elementCodec is null");
    }

    @Override
    public ThriftType getType() {
        return this.type;
    }

    @Override
    public Optional<T> read(TProtocolReader protocol) throws Exception {
        Objects.requireNonNull(protocol, "protocol is null");
        return Optional.of(this.elementCodec.read(protocol));
    }

    @Override
    public void write(Optional<T> value, TProtocolWriter protocol) throws Exception {
        Objects.requireNonNull(value, "value is null");
        Objects.requireNonNull(protocol, "protocol is null");
        if (!value.isPresent()) {
            throw new IllegalArgumentException("value is not present");
        }
        this.elementCodec.write(value.get(), protocol);
    }

    @Override
    public boolean isNull(Optional<T> value) {
        return value == null || !value.isPresent();
    }
}

