/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drift.codec.metadata;

import com.facebook.drift.annotations.ThriftField;
import com.facebook.drift.codec.metadata.FieldKind;
import com.facebook.drift.codec.metadata.Injection;
import com.facebook.drift.codec.metadata.ReflectionHelper;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.lang.reflect.Type;
import java.util.Objects;

class ParameterInjection
extends Injection {
    private final int parameterIndex;
    private final String extractedName;
    private final Type parameterJavaType;
    private final Type thriftStructType;

    ParameterInjection(Type thriftStructType, int parameterIndex, ThriftField annotation, String extractedName, Type parameterJavaType) {
        super(annotation, FieldKind.THRIFT_FIELD);
        this.thriftStructType = thriftStructType;
        Objects.requireNonNull(parameterJavaType, "parameterJavaType is null");
        this.parameterIndex = parameterIndex;
        this.extractedName = extractedName;
        this.parameterJavaType = parameterJavaType;
        if (Void.TYPE.equals(parameterJavaType)) {
            throw new AssertionError();
        }
        Preconditions.checkArgument((this.getName() != null || extractedName != null ? 1 : 0) != 0, (Object)"Parameter must have an explicit name or an extractedName");
    }

    public int getParameterIndex() {
        return this.parameterIndex;
    }

    @Override
    public String extractName() {
        return this.extractedName;
    }

    @Override
    public Type getJavaType() {
        return ReflectionHelper.resolveFieldType(this.thriftStructType, this.parameterJavaType);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("parameterIndex", this.parameterIndex).add("extractedName", (Object)this.extractedName).add("parameterJavaType", (Object)this.parameterJavaType).toString();
    }
}

