/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.bytecode.expression;

import com.facebook.airlift.bytecode.BytecodeBlock;
import com.facebook.airlift.bytecode.BytecodeNode;
import com.facebook.airlift.bytecode.MethodGenerationContext;
import com.facebook.airlift.bytecode.ParameterizedType;
import com.facebook.airlift.bytecode.expression.BytecodeExpression;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;

class InstanceOfBytecodeExpression
extends BytecodeExpression {
    private final BytecodeExpression instance;
    private final Class<?> type;

    public InstanceOfBytecodeExpression(BytecodeExpression instance, Class<?> type) {
        super(ParameterizedType.type(Boolean.TYPE));
        this.instance = Objects.requireNonNull(instance, "instance is null");
        this.type = Objects.requireNonNull(type, "type is null");
    }

    public static BytecodeExpression instanceOf(BytecodeExpression instance, Class<?> type) {
        return new InstanceOfBytecodeExpression(instance, type);
    }

    @Override
    public BytecodeNode getBytecode(MethodGenerationContext generationContext) {
        return new BytecodeBlock().append(this.instance).isInstanceOf(this.type);
    }

    @Override
    protected String formatOneLine() {
        return this.instance + " instanceof " + this.type;
    }

    @Override
    public List<BytecodeNode> getChildNodes() {
        return ImmutableList.of();
    }
}

