/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drift.codec.internal.builtin;

import com.facebook.drift.codec.ThriftCodec;
import com.facebook.drift.codec.internal.ProtocolReader;
import com.facebook.drift.codec.internal.ProtocolWriter;
import com.facebook.drift.codec.metadata.ThriftType;
import com.facebook.drift.protocol.TProtocolReader;
import com.facebook.drift.protocol.TProtocolWriter;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ShortArrayThriftCodec
implements ThriftCodec<short[]> {
    @Override
    public ThriftType getType() {
        return ThriftType.array(ThriftType.I16);
    }

    @Override
    public short[] read(TProtocolReader protocol) throws Exception {
        Objects.requireNonNull(protocol, "protocol is null");
        return new ProtocolReader(protocol).readI16Array();
    }

    @Override
    public void write(short[] value, TProtocolWriter protocol) throws Exception {
        Objects.requireNonNull(value, "value is null");
        Objects.requireNonNull(protocol, "protocol is null");
        new ProtocolWriter(protocol).writeI16Array(value);
    }
}

