/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drift.codec.metadata;

import com.facebook.drift.codec.metadata.ThriftParameterInjection;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ThriftConstructorInjection {
    private final Constructor<?> constructor;
    private final List<ThriftParameterInjection> parameters;

    public ThriftConstructorInjection(Constructor<?> constructor, ThriftParameterInjection ... parameters) {
        this(Objects.requireNonNull(constructor, "constructor is null"), (List<ThriftParameterInjection>)ImmutableList.copyOf((Object[])Objects.requireNonNull(parameters, "parameters is null")));
    }

    public ThriftConstructorInjection(Constructor<?> constructor, List<ThriftParameterInjection> parameters) {
        this.constructor = Objects.requireNonNull(constructor, "constructor is null");
        this.parameters = ImmutableList.copyOf((Collection)Objects.requireNonNull(parameters, "parameters is null"));
    }

    public Constructor<?> getConstructor() {
        return this.constructor;
    }

    public List<ThriftParameterInjection> getParameters() {
        return this.parameters;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.constructor.getName());
        sb.append('(');
        Joiner.on((String)", ").appendTo(sb, this.parameters);
        sb.append(')');
        return sb.toString();
    }
}

