/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.log;

import com.facebook.airlift.log.Level;
import com.facebook.airlift.log.Logger;
import com.facebook.airlift.log.LoggingConfiguration;
import com.facebook.airlift.log.LoggingOutputStream;
import com.facebook.airlift.log.NonCloseableOutputStream;
import com.facebook.airlift.log.OutputStreamHandler;
import com.facebook.airlift.log.RollingFileHandler;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Handler;
import java.util.logging.LogManager;
import javax.annotation.concurrent.GuardedBy;

public class Logging {
    private static final Logger log = Logger.get(Logging.class);
    private static final String ROOT_LOGGER_NAME = "";
    private static final java.util.logging.Logger ROOT = java.util.logging.Logger.getLogger("");
    private static Logging instance;
    private final Map<String, java.util.logging.Logger> loggers = new ConcurrentHashMap<String, java.util.logging.Logger>();
    @GuardedBy(value="this")
    private OutputStreamHandler consoleHandler;

    public static synchronized Logging initialize() {
        if (instance == null) {
            instance = new Logging();
        }
        return instance;
    }

    private Logging() {
        ROOT.setLevel(Level.INFO.toJulLevel());
        for (Handler handler : ROOT.getHandlers()) {
            ROOT.removeHandler(handler);
        }
        this.rewireStdStreams();
    }

    private void rewireStdStreams() {
        this.logConsole(new NonCloseableOutputStream(System.err));
        log.info("Logging to stderr");
        Logging.redirectStdStreams();
    }

    private static void redirectStdStreams() {
        System.setOut(new PrintStream(new LoggingOutputStream(Logger.get((String)"stdout")), true));
        System.setErr(new PrintStream(new LoggingOutputStream(Logger.get((String)"stderr")), true));
    }

    private synchronized void logConsole(OutputStream stream) {
        this.consoleHandler = new OutputStreamHandler(stream);
        ROOT.addHandler(this.consoleHandler);
    }

    public synchronized void disableConsole() {
        log.info("Disabling stderr output");
        ROOT.removeHandler(this.consoleHandler);
        this.consoleHandler = null;
    }

    public void logToFile(String logPath, int maxHistory, long maxSizeInBytes) {
        log.info("Logging to %s", new Object[]{logPath});
        RollingFileHandler rollingFileHandler = new RollingFileHandler(logPath, maxHistory, maxSizeInBytes);
        ROOT.addHandler(rollingFileHandler);
    }

    public Level getRootLevel() {
        return this.getLevel(ROOT_LOGGER_NAME);
    }

    public void setRootLevel(Level newLevel) {
        this.setLevel(ROOT_LOGGER_NAME, newLevel);
    }

    public void setLevels(File file) throws IOException {
        Properties properties = new Properties();
        try (FileInputStream inputStream = new FileInputStream(file);){
            properties.load(inputStream);
        }
        Maps.fromProperties((Properties)properties).forEach((loggerName, value) -> this.setLevel((String)loggerName, Level.valueOf(value.toUpperCase(Locale.US))));
    }

    public Level getLevel(String loggerName) {
        return Logging.getEffectiveLevel(java.util.logging.Logger.getLogger(loggerName));
    }

    private static Level getEffectiveLevel(java.util.logging.Logger logger) {
        java.util.logging.Logger parent;
        java.util.logging.Level level = logger.getLevel();
        if (level == null && (parent = logger.getParent()) != null) {
            return Logging.getEffectiveLevel(parent);
        }
        if (level == null) {
            return Level.OFF;
        }
        return Level.fromJulLevel(level);
    }

    public void setLevel(String loggerName, Level level) {
        this.loggers.computeIfAbsent(loggerName, java.util.logging.Logger::getLogger).setLevel(level.toJulLevel());
    }

    public Map<String, Level> getAllLevels() {
        ImmutableSortedMap.Builder levels = ImmutableSortedMap.naturalOrder();
        for (String loggerName : Collections.list(LogManager.getLogManager().getLoggerNames())) {
            java.util.logging.Level level = java.util.logging.Logger.getLogger(loggerName).getLevel();
            if (level == null) continue;
            levels.put((Object)loggerName, (Object)Level.fromJulLevel(level));
        }
        return levels.build();
    }

    public void configure(LoggingConfiguration config) {
        if (config.getLogPath() != null) {
            this.logToFile(config.getLogPath(), config.getMaxHistory(), config.getMaxSize().toBytes());
        }
        if (!config.isConsoleEnabled()) {
            this.disableConsole();
        }
        if (config.getLevelsFile() != null) {
            try {
                this.setLevels(new File(config.getLevelsFile()));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }
}

