/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drift.client;

import com.facebook.drift.client.MethodInvocationFilter;
import com.facebook.drift.transport.client.InvokeRequest;
import com.facebook.drift.transport.client.MethodInvoker;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.units.Duration;
import java.util.List;
import java.util.Objects;

class FilteredMethodInvoker
implements MethodInvoker {
    private final MethodInvocationFilter filter;
    private final MethodInvoker next;

    public static MethodInvoker createFilteredMethodInvoker(List<MethodInvocationFilter> filters, MethodInvoker methodInvoker) {
        for (MethodInvocationFilter filter : Lists.reverse(filters)) {
            methodInvoker = new FilteredMethodInvoker(filter, methodInvoker);
        }
        return methodInvoker;
    }

    private FilteredMethodInvoker(MethodInvocationFilter filter, MethodInvoker next) {
        this.filter = Objects.requireNonNull(filter, "filter is null");
        this.next = Objects.requireNonNull(next, "next is null");
    }

    public ListenableFuture<Object> invoke(InvokeRequest request) {
        return this.filter.invoke(request, this.next);
    }

    public ListenableFuture<?> delay(Duration duration) {
        return this.next.delay(duration);
    }
}

