/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drift.protocol;

import com.facebook.drift.TException;
import com.facebook.drift.protocol.TField;
import com.facebook.drift.protocol.TList;
import com.facebook.drift.protocol.TMap;
import com.facebook.drift.protocol.TProtocolException;
import com.facebook.drift.protocol.TProtocolReader;
import com.facebook.drift.protocol.TSet;
import com.facebook.drift.protocol.TTransport;

public final class TProtocolUtil {
    private TProtocolUtil() {
    }

    public static void skip(TProtocolReader protocol, byte type) throws TException {
        switch (type) {
            case 0: {
                return;
            }
            case 2: {
                protocol.readBool();
                return;
            }
            case 3: {
                protocol.readByte();
                return;
            }
            case 6: {
                protocol.readI16();
                return;
            }
            case 8: {
                protocol.readI32();
                return;
            }
            case 10: {
                protocol.readI64();
                return;
            }
            case 19: {
                protocol.readFloat();
                return;
            }
            case 4: {
                protocol.readDouble();
                return;
            }
            case 11: {
                protocol.readBinary();
                return;
            }
            case 12: {
                TField field;
                protocol.readStructBegin();
                while ((field = protocol.readFieldBegin()).getType() != 0) {
                    TProtocolUtil.skip(protocol, field.getType());
                    protocol.readFieldEnd();
                }
                protocol.readStructEnd();
                return;
            }
            case 13: {
                TMap map = protocol.readMapBegin();
                for (int i = 0; i < map.getSize(); ++i) {
                    TProtocolUtil.skip(protocol, map.getKeyType());
                    TProtocolUtil.skip(protocol, map.getValueType());
                }
                protocol.readMapEnd();
                return;
            }
            case 14: {
                TSet set = protocol.readSetBegin();
                for (int i = 0; i < set.getSize(); ++i) {
                    TProtocolUtil.skip(protocol, set.getType());
                }
                protocol.readSetEnd();
                return;
            }
            case 15: {
                TList list = protocol.readListBegin();
                for (int i = 0; i < list.getSize(); ++i) {
                    TProtocolUtil.skip(protocol, list.getType());
                }
                protocol.readListEnd();
                return;
            }
        }
        throw new TProtocolException("Unknown type: " + type);
    }

    public static int readAllInBatches(TTransport transport, byte[] buf, int offset, int size) throws TException {
        int remainingLength = size;
        while (remainingLength > 0) {
            int readSize = Math.min(remainingLength, 65536);
            transport.read(buf, offset, readSize);
            remainingLength -= readSize;
            offset += readSize;
        }
        return size;
    }
}

