/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.functions.type;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.SingleMapBlock;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.DecimalType;
import com.facebook.presto.common.type.MapType;
import com.facebook.presto.common.type.RowType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.hive.functions.HiveFunctionErrorCode;
import com.facebook.presto.hive.functions.type.BlockInputDecoder;
import com.facebook.presto.hive.functions.type.DateTimeUtils;
import com.facebook.presto.hive.functions.type.DecimalUtils;
import com.facebook.presto.hive.functions.type.HiveTypes;
import com.google.common.base.Preconditions;
import com.google.common.collect.Streams;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ConstantObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.SettableStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BinaryObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BooleanObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.ByteObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DateObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DoubleObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.FloatObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveDecimalObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.IntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.JavaDateObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.JavaHiveCharObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.JavaHiveDecimalObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.JavaHiveVarcharObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.JavaTimestampObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.LongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.ShortObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.TimestampObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.VoidObjectInspector;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;

public final class BlockInputDecoders {
    private BlockInputDecoders() {
    }

    public static BlockInputDecoder createBlockInputDecoder(ObjectInspector inspector, Type type) {
        if (inspector instanceof ConstantObjectInspector) {
            Object constant = ((ConstantObjectInspector)inspector).getWritableConstantValue();
            return (b, i) -> constant;
        }
        if (inspector instanceof PrimitiveObjectInspector) {
            return BlockInputDecoders.createForPrimitive((PrimitiveObjectInspector)inspector, type);
        }
        if (inspector instanceof StandardStructObjectInspector) {
            Preconditions.checkArgument((boolean)(type instanceof RowType));
            return BlockInputDecoders.createForStruct((StandardStructObjectInspector)inspector, (RowType)type);
        }
        if (inspector instanceof SettableStructObjectInspector) {
            return BlockInputDecoders.createForStruct((SettableStructObjectInspector)inspector, (RowType)type);
        }
        if (inspector instanceof StructObjectInspector) {
            return BlockInputDecoders.createForStruct((StructObjectInspector)inspector, (RowType)type);
        }
        if (inspector instanceof ListObjectInspector) {
            Preconditions.checkArgument((boolean)(type instanceof ArrayType));
            return BlockInputDecoders.createForList((ListObjectInspector)inspector, (ArrayType)type);
        }
        if (inspector instanceof MapObjectInspector) {
            Preconditions.checkArgument((boolean)(type instanceof MapType));
            return BlockInputDecoders.createForMap((MapObjectInspector)inspector, (MapType)type);
        }
        throw HiveFunctionErrorCode.unsupportedType(inspector);
    }

    private static BlockInputDecoder createForPrimitive(PrimitiveObjectInspector inspector, Type type) {
        boolean preferWritable = inspector.preferWritable();
        if (inspector instanceof StringObjectInspector) {
            return preferWritable ? (b, i) -> b.isNull(i) ? null : new Text(type.getSlice(b, i).getBytes()) : (b, i) -> b.isNull(i) ? null : type.getSlice(b, i).toStringUtf8();
        }
        if (inspector instanceof IntObjectInspector) {
            return preferWritable ? (b, i) -> b.isNull(i) ? null : new IntWritable((int)type.getLong(b, i)) : (b, i) -> b.isNull(i) ? null : Integer.valueOf((int)type.getLong(b, i));
        }
        if (inspector instanceof BooleanObjectInspector) {
            return preferWritable ? (b, i) -> b.isNull(i) ? null : new BooleanWritable(type.getBoolean(b, i)) : (b, i) -> b.isNull(i) ? null : Boolean.valueOf(type.getBoolean(b, i));
        }
        if (inspector instanceof FloatObjectInspector) {
            return preferWritable ? (b, i) -> b.isNull(i) ? null : new FloatWritable(Float.intBitsToFloat((int)type.getLong(b, i))) : (b, i) -> b.isNull(i) ? null : Float.valueOf(Float.intBitsToFloat((int)type.getLong(b, i)));
        }
        if (inspector instanceof DoubleObjectInspector) {
            return preferWritable ? (b, i) -> b.isNull(i) ? null : new DoubleWritable(type.getDouble(b, i)) : (b, i) -> b.isNull(i) ? null : Double.valueOf(type.getDouble(b, i));
        }
        if (inspector instanceof LongObjectInspector) {
            return preferWritable ? (b, i) -> b.isNull(i) ? null : new LongWritable(type.getLong(b, i)) : (b, i) -> b.isNull(i) ? null : Long.valueOf(type.getLong(b, i));
        }
        if (inspector instanceof ShortObjectInspector) {
            return preferWritable ? (b, i) -> b.isNull(i) ? null : new ShortWritable((short)type.getLong(b, i)) : (b, i) -> b.isNull(i) ? null : Short.valueOf((short)type.getLong(b, i));
        }
        if (inspector instanceof ByteObjectInspector) {
            return preferWritable ? (b, i) -> b.isNull(i) ? null : new ByteWritable((byte)type.getLong(b, i)) : (b, i) -> b.isNull(i) ? null : Byte.valueOf((byte)type.getLong(b, i));
        }
        if (inspector instanceof JavaHiveVarcharObjectInspector) {
            return (b, i) -> b.isNull(i) ? null : HiveTypes.createHiveVarChar(type.getSlice(b, i).toStringUtf8());
        }
        if (inspector instanceof JavaHiveCharObjectInspector) {
            return (b, i) -> b.isNull(i) ? null : HiveTypes.createHiveChar(type.getSlice(b, i).toStringUtf8());
        }
        if (inspector instanceof JavaHiveDecimalObjectInspector) {
            Preconditions.checkArgument((boolean)(type instanceof DecimalType));
            return (b, i) -> b.isNull(i) ? null : DecimalUtils.readHiveDecimal((DecimalType)type, b, i);
        }
        if (inspector instanceof JavaDateObjectInspector) {
            return (b, i) -> b.isNull(i) ? null : new Date(TimeUnit.DAYS.toMillis(type.getLong(b, i)));
        }
        if (inspector instanceof JavaTimestampObjectInspector) {
            return (b, i) -> b.isNull(i) ? null : new Timestamp(type.getLong(b, i));
        }
        if (inspector instanceof HiveDecimalObjectInspector) {
            Preconditions.checkArgument((boolean)(type instanceof DecimalType));
            return preferWritable ? (b, i) -> b.isNull(i) ? null : new HiveDecimalWritable(DecimalUtils.readHiveDecimal((DecimalType)type, b, i)) : (b, i) -> b.isNull(i) ? null : DecimalUtils.readHiveDecimal((DecimalType)type, b, i);
        }
        if (inspector instanceof BinaryObjectInspector) {
            return preferWritable ? (b, i) -> b.isNull(i) ? null : new BytesWritable(type.getSlice(b, i).getBytes()) : (b, i) -> b.isNull(i) ? null : type.getSlice(b, i).getBytes();
        }
        if (inspector instanceof DateObjectInspector) {
            return preferWritable ? (b, i) -> b.isNull(i) ? null : new DateWritable((int)type.getLong(b, i)) : (b, i) -> b.isNull(i) ? null : DateTimeUtils.createDate((int)type.getLong(b, i));
        }
        if (inspector instanceof TimestampObjectInspector) {
            return preferWritable ? (b, i) -> b.isNull(i) ? null : new TimestampWritable(new Timestamp(type.getLong(b, i))) : (b, i) -> b.isNull(i) ? null : new Timestamp(type.getLong(b, i));
        }
        if (inspector instanceof VoidObjectInspector) {
            return (b, i) -> null;
        }
        throw HiveFunctionErrorCode.unsupportedType((ObjectInspector)inspector);
    }

    private static BlockInputDecoder createForStruct(StandardStructObjectInspector structInspector, RowType rowType) {
        List structFields = structInspector.getAllStructFieldRefs();
        List rowFields = rowType.getFields();
        Preconditions.checkArgument((rowFields.size() == structFields.size() ? 1 : 0) != 0);
        List fieldDecoders = Streams.zip(structFields.stream(), rowFields.stream(), (sf, rf) -> BlockInputDecoders.createBlockInputDecoder(sf.getFieldObjectInspector(), rf.getType())).collect(Collectors.toList());
        int numFields = structFields.size();
        return (b, i) -> {
            if (b.isNull(i)) {
                return null;
            }
            Block row = b.getBlock(i);
            Object result = structInspector.create();
            for (int j = 0; j < numFields; ++j) {
                structInspector.setStructFieldData(result, (StructField)structFields.get(j), ((BlockInputDecoder)fieldDecoders.get(j)).decode(row, j));
            }
            return result;
        };
    }

    private static BlockInputDecoder createForStruct(SettableStructObjectInspector structInspector, RowType rowType) {
        List structFields = structInspector.getAllStructFieldRefs();
        List rowFields = rowType.getFields();
        Preconditions.checkArgument((rowFields.size() == structFields.size() ? 1 : 0) != 0);
        List fieldDecoders = Streams.zip(structFields.stream(), rowFields.stream(), (sf, rf) -> BlockInputDecoders.createBlockInputDecoder(sf.getFieldObjectInspector(), rf.getType())).collect(Collectors.toList());
        int numFields = structFields.size();
        return (b, i) -> {
            if (b.isNull(i)) {
                return null;
            }
            Block row = b.getBlock(i);
            Object result = structInspector.create();
            for (int j = 0; j < numFields; ++j) {
                structInspector.setStructFieldData(result, (StructField)structFields.get(j), ((BlockInputDecoder)fieldDecoders.get(j)).decode(row, j));
            }
            return result;
        };
    }

    private static BlockInputDecoder createForStruct(StructObjectInspector structInspector, RowType rowType) {
        List structFields = structInspector.getAllStructFieldRefs();
        List rowFields = rowType.getFields();
        Preconditions.checkArgument((rowFields.size() == structFields.size() ? 1 : 0) != 0);
        List fieldDecoders = Streams.zip(structFields.stream(), rowFields.stream(), (sf, rf) -> BlockInputDecoders.createBlockInputDecoder(sf.getFieldObjectInspector(), rf.getType())).collect(Collectors.toList());
        int numFields = structFields.size();
        return (b, i) -> {
            if (b.isNull(i)) {
                return null;
            }
            Block row = b.getBlock(i);
            ArrayList<Object> result = new ArrayList<Object>(numFields);
            for (int j = 0; j < numFields; ++j) {
                result.add(((BlockInputDecoder)fieldDecoders.get(j)).decode(row, j));
            }
            return result;
        };
    }

    private static BlockInputDecoder createForList(ListObjectInspector inspector, ArrayType arrayType) {
        Type elementType = arrayType.getElementType();
        ObjectInspector elementInspector = inspector.getListElementObjectInspector();
        BlockInputDecoder decoder = BlockInputDecoders.createBlockInputDecoder(elementInspector, elementType);
        return (b, i) -> {
            if (b.isNull(i)) {
                return null;
            }
            Block array = b.getBlock(i);
            int positions = array.getPositionCount();
            ArrayList<Object> result = new ArrayList<Object>(positions);
            for (int j = 0; j < positions; ++j) {
                result.add(decoder.decode(array, j));
            }
            return result;
        };
    }

    private static BlockInputDecoder createForMap(MapObjectInspector inspector, MapType mapType) {
        Type keyType = mapType.getKeyType();
        Type valueType = mapType.getValueType();
        ObjectInspector keyInspector = inspector.getMapKeyObjectInspector();
        ObjectInspector valueInspector = inspector.getMapValueObjectInspector();
        BlockInputDecoder keyDecoder = BlockInputDecoders.createBlockInputDecoder(keyInspector, keyType);
        BlockInputDecoder valueDecoder = BlockInputDecoders.createBlockInputDecoder(valueInspector, valueType);
        return (b, i) -> {
            if (b.isNull(i)) {
                return null;
            }
            SingleMapBlock single = (SingleMapBlock)b.getBlock(i);
            int positions = single.getPositionCount();
            HashMap<Object, Object> result = new HashMap<Object, Object>();
            for (int j = 0; j < positions; j += 2) {
                Object key = keyDecoder.decode((Block)single, j);
                Object value = valueDecoder.decode((Block)single, j + 1);
                if (key == null) continue;
                result.put(key, value);
            }
            return result;
        };
    }
}

