/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.functions.type;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.type.DecimalType;
import com.facebook.presto.common.type.Decimals;
import io.airlift.slice.Slice;
import java.math.BigDecimal;
import org.apache.hadoop.hive.common.type.HiveDecimal;

public final class DecimalUtils {
    private DecimalUtils() {
    }

    public static long encodeToLong(BigDecimal decimal, DecimalType type) {
        return Decimals.rescale((BigDecimal)decimal, (DecimalType)type).unscaledValue().longValue();
    }

    public static Slice encodeToSlice(BigDecimal decimal, DecimalType type) {
        return Decimals.encodeScaledValue((BigDecimal)Decimals.rescale((BigDecimal)decimal, (DecimalType)type));
    }

    public static HiveDecimal readHiveDecimal(DecimalType type, Block block, int position) {
        BigDecimal bigDecimal = Decimals.readBigDecimal((DecimalType)type, (Block)block, (int)position);
        return HiveDecimal.create((BigDecimal)bigDecimal);
    }
}

