/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.$internal.jodd.util;

import com.facebook.presto.hive.$internal.jodd.util.ClassLoaderUtil;
import com.facebook.presto.hive.$internal.jodd.util.LocaleUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;

public class ResourceBundleMessageResolver {
    protected Locale fallbackLocale = LocaleUtil.getLocale("en");
    protected String fallbackBundlename = "messages";
    protected List<String> defaultBundles = new ArrayList<String>();
    protected boolean cacheResourceBundles = true;
    protected final Set<String> misses = new HashSet<String>();
    protected final Map<String, ResourceBundle> notmisses = new HashMap<String, ResourceBundle>();

    public void addDefaultBundle(String bundleName) {
        this.defaultBundles.add(bundleName);
    }

    public void deleteAllDefaultBundles() {
        this.defaultBundles.clear();
    }

    private String calcIndexKey(String key) {
        String indexedKey = null;
        if (key.indexOf(91) != -1) {
            int i = -1;
            indexedKey = key;
            while ((i = indexedKey.indexOf(91, i + 1)) != -1) {
                int j = indexedKey.indexOf(93, i);
                String a = indexedKey.substring(0, i);
                String b = indexedKey.substring(j);
                indexedKey = a + "[*" + b;
            }
        }
        return indexedKey;
    }

    private String getMessage(String bundleName, Locale locale, String key, String indexedKey) {
        String msg = this.getMessage(bundleName, locale, key);
        if (msg != null) {
            return msg;
        }
        if (indexedKey != null && (msg = this.getMessage(bundleName, locale, indexedKey)) != null) {
            return msg;
        }
        return null;
    }

    public String findMessage(String bundleName, Locale locale, String key) {
        String indexedKey = this.calcIndexKey(key);
        String name = bundleName;
        while (true) {
            String msg;
            if ((msg = this.getMessage(name, locale, key, indexedKey)) != null) {
                return msg;
            }
            if (bundleName == null || bundleName.length() == 0) break;
            int ndx = bundleName.lastIndexOf(46);
            if (ndx == -1) {
                bundleName = null;
                name = this.fallbackBundlename;
                continue;
            }
            bundleName = bundleName.substring(0, ndx);
            name = bundleName + '.' + this.fallbackBundlename;
        }
        for (String bname : this.defaultBundles) {
            String msg = this.getMessage(bname, locale, key, indexedKey);
            if (msg == null) continue;
            return msg;
        }
        return null;
    }

    public String findDefaultMessage(Locale locale, String key) {
        String indexedKey = this.calcIndexKey(key);
        String msg = this.getMessage(this.fallbackBundlename, locale, key, indexedKey);
        if (msg != null) {
            return msg;
        }
        for (String bname : this.defaultBundles) {
            msg = this.getMessage(bname, locale, key, indexedKey);
            if (msg == null) continue;
            return msg;
        }
        return null;
    }

    public String getMessage(String bundleName, Locale locale, String key) {
        ResourceBundle bundle = this.findResourceBundle(bundleName, locale);
        if (bundle == null) {
            return null;
        }
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException mrex) {
            return null;
        }
    }

    public ResourceBundle findResourceBundle(String bundleName, Locale locale) {
        if (bundleName == null) {
            bundleName = this.fallbackBundlename;
        }
        if (locale == null) {
            locale = this.fallbackLocale;
        }
        if (!this.cacheResourceBundles) {
            try {
                return this.getBundle(bundleName, locale, ClassLoaderUtil.getDefaultClassLoader());
            }
            catch (MissingResourceException ignore) {
                return null;
            }
        }
        String key = bundleName + '_' + LocaleUtil.resolveLocaleCode(locale);
        try {
            if (!this.misses.contains(key)) {
                ResourceBundle bundle = this.notmisses.get(key);
                if (bundle == null) {
                    bundle = this.getBundle(bundleName, locale, ClassLoaderUtil.getDefaultClassLoader());
                    this.notmisses.put(key, bundle);
                }
                return bundle;
            }
        }
        catch (MissingResourceException ignore) {
            this.misses.add(key);
        }
        return null;
    }

    protected ResourceBundle getBundle(String bundleName, Locale locale, ClassLoader classLoader) {
        return ResourceBundle.getBundle(bundleName, locale, classLoader);
    }

    public String getFallbackBundlename() {
        return this.fallbackBundlename;
    }

    public void setFallbackBundlename(String fallbackBundlename) {
        this.fallbackBundlename = fallbackBundlename;
    }

    public Locale getFallbackLocale() {
        return this.fallbackLocale;
    }

    public void setFallbackLocale(Locale fallbackLocale) {
        this.fallbackLocale = fallbackLocale;
    }

    public void setFallbackLocale(String localeCode) {
        this.fallbackLocale = LocaleUtil.getLocale(localeCode);
    }

    public boolean isCacheResourceBundles() {
        return this.cacheResourceBundles;
    }

    public void setCacheResourceBundles(boolean cacheResourceBundles) {
        this.cacheResourceBundles = cacheResourceBundles;
    }
}

