/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.mapred;

import com.facebook.presto.hive.$internal.org.slf4j.Logger;
import com.facebook.presto.hive.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.mapred.AvroInputFormat;
import org.apache.avro.mapred.AvroJob;
import org.apache.avro.mapred.AvroMapper;
import org.apache.avro.mapred.AvroMultipleInputs;
import org.apache.avro.mapred.TaggedInputSplit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.ReflectionUtils;

class DelegatingInputFormat<K, V>
implements InputFormat<K, V> {
    private static final Logger LOG = LoggerFactory.getLogger(DelegatingInputFormat.class);

    DelegatingInputFormat() {
    }

    public InputSplit[] getSplits(JobConf conf, int numSplits) throws IOException {
        JobConf confCopy = new JobConf((Configuration)conf);
        ArrayList<TaggedInputSplit> splits = new ArrayList<TaggedInputSplit>();
        Map<Path, Class<? extends AvroMapper>> mapperMap = AvroMultipleInputs.getMapperTypeMap(conf);
        Map<Path, Schema> schemaMap = AvroMultipleInputs.getInputSchemaMap(conf);
        HashMap schemaPaths = new HashMap();
        for (Map.Entry<Path, Schema> entry : schemaMap.entrySet()) {
            if (!schemaPaths.containsKey(entry.getValue())) {
                schemaPaths.put(entry.getValue(), new ArrayList());
                LOG.info(entry.getValue().toString());
                LOG.info(String.valueOf(entry.getKey()));
            }
            ((List)schemaPaths.get(entry.getValue())).add(entry.getKey());
        }
        for (Map.Entry<Object, Schema> entry : schemaPaths.entrySet()) {
            Class mapperClass;
            Schema schema = (Schema)entry.getKey();
            LOG.info(schema.toString());
            InputFormat format = (InputFormat)ReflectionUtils.newInstance(AvroInputFormat.class, (Configuration)conf);
            List paths = (List)((Object)entry.getValue());
            HashMap mapperPaths = new HashMap();
            for (Path path : paths) {
                mapperClass = mapperMap.get(path);
                if (!mapperPaths.containsKey(mapperClass)) {
                    mapperPaths.put(mapperClass, new ArrayList());
                }
                ((List)mapperPaths.get(mapperClass)).add(path);
            }
            for (Map.Entry entry2 : mapperPaths.entrySet()) {
                InputSplit[] pathSplits;
                paths = (List)entry2.getValue();
                mapperClass = (Class)entry2.getKey();
                if (mapperClass == null) {
                    mapperClass = conf.getMapperClass();
                }
                FileInputFormat.setInputPaths((JobConf)confCopy, (Path[])paths.toArray(new Path[0]));
                for (InputSplit pathSplit : pathSplits = format.getSplits(confCopy, numSplits)) {
                    splits.add(new TaggedInputSplit(pathSplit, (Configuration)conf, format.getClass(), mapperClass, schema));
                }
            }
        }
        return splits.toArray(new InputSplit[0]);
    }

    public RecordReader<K, V> getRecordReader(InputSplit split, JobConf conf, Reporter reporter) throws IOException {
        TaggedInputSplit taggedInputSplit = (TaggedInputSplit)split;
        Schema schema = taggedInputSplit.getSchema();
        AvroJob.setInputSchema(conf, schema);
        InputFormat inputFormat = (InputFormat)ReflectionUtils.newInstance(taggedInputSplit.getInputFormatClass(), (Configuration)conf);
        return inputFormat.getRecordReader(taggedInputSplit.getInputSplit(), conf, reporter);
    }
}

