/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.messaging.json;

import com.facebook.presto.hive.$internal.org.codehaus.jackson.annotate.JsonProperty;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.messaging.DropTableMessage;
import org.apache.hadoop.hive.metastore.messaging.json.JSONMessageDeserializer;
import org.apache.hadoop.hive.metastore.messaging.json.JSONMessageFactory;
import org.apache.thrift.TException;

public class JSONDropTableMessage
extends DropTableMessage {
    @JsonProperty
    String server;
    @JsonProperty
    String servicePrincipal;
    @JsonProperty
    String db;
    @JsonProperty
    String table;
    @JsonProperty
    String tableType;
    @JsonProperty
    String tableObjJson;
    @JsonProperty
    Long timestamp;

    public JSONDropTableMessage() {
    }

    public JSONDropTableMessage(String server, String servicePrincipal, String db, String table, Long timestamp) {
        this(server, servicePrincipal, db, table, null, timestamp);
    }

    public JSONDropTableMessage(String server, String servicePrincipal, String db, String table, String tableType, Long timestamp) {
        this.server = server;
        this.servicePrincipal = servicePrincipal;
        this.db = db;
        this.table = table;
        this.tableType = tableType;
        this.timestamp = timestamp;
        this.checkValid();
    }

    public JSONDropTableMessage(String server, String servicePrincipal, Table tableObj, Long timestamp) {
        this(server, servicePrincipal, tableObj.getDbName(), tableObj.getTableName(), tableObj.getTableType(), timestamp);
        try {
            this.tableObjJson = JSONMessageFactory.createTableObjJson(tableObj);
        }
        catch (TException e) {
            throw new IllegalArgumentException("Could not serialize: ", e);
        }
        this.checkValid();
    }

    @Override
    public String getTable() {
        return this.table;
    }

    @Override
    public String getTableType() {
        if (this.tableType != null) {
            return this.tableType;
        }
        return "";
    }

    @Override
    public Table getTableObj() throws Exception {
        return (Table)JSONMessageFactory.getTObj(this.tableObjJson, Table.class);
    }

    @Override
    public String getServer() {
        return this.server;
    }

    @Override
    public String getServicePrincipal() {
        return this.servicePrincipal;
    }

    @Override
    public String getDB() {
        return this.db;
    }

    @Override
    public Long getTimestamp() {
        return this.timestamp;
    }

    public String toString() {
        try {
            return JSONMessageDeserializer.mapper.writeValueAsString(this);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Could not serialize: ", exception);
        }
    }
}

