/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.tools;

import com.facebook.presto.hive.;
import com.facebook.presto.hive.$internal.org.slf4j.Logger;
import com.facebook.presto.hive.$internal.org.slf4j.LoggerFactory;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.ObjectStore;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.utils.StringUtils;
import org.apache.orc.OrcFile;
import org.apache.orc.Reader;
import org.apache.orc.impl.AcidStats;
import org.apache.orc.impl.OrcAcidUtils;
import org.apache.thrift.TException;

public class HiveMetaTool {
    private static final Logger LOG = LoggerFactory.getLogger(HiveMetaTool.class.getName());
    private final .Options cmdLineOptions = new .Options();
    private ObjectStore objStore;
    private boolean isObjStoreInitialized = false;

    private void init() {
        System.out.println("Initializing HiveMetaTool..");
        .Option help = new .Option("help", "print this message");
        .Option listFSRoot = new .Option("listFSRoot", "print the current FS root locations");
        .OptionBuilder.withArgName((String)"query-string");
        .OptionBuilder.hasArgs();
        .OptionBuilder.withDescription((String)"execute the given JDOQL query");
        .Option executeJDOQL = .OptionBuilder.create((String)"executeJDOQL");
        .OptionBuilder.withArgName((String)"new-loc> <old-loc");
        .OptionBuilder.hasArgs((int)2);
        .OptionBuilder.withDescription((String)"Update FS root location in the metastore to new location.Both new-loc and old-loc should be valid URIs with valid host names and schemes.When run with the dryRun option changes are displayed but are not persisted. When run with the serdepropKey/tablePropKey option updateLocation looks for the serde-prop-key/table-prop-key that is specified and updates its value if found.");
        .Option updateFSRootLoc = .OptionBuilder.create((String)"updateLocation");
        .Option dryRun = new .Option("dryRun", "Perform a dry run of updateLocation changes.When run with the dryRun option updateLocation changes are displayed but not persisted. dryRun is valid only with the updateLocation option.");
        .OptionBuilder.withArgName((String)"serde-prop-key");
        .OptionBuilder.hasArgs();
        .OptionBuilder.withValueSeparator();
        .OptionBuilder.withDescription((String)"Specify the key for serde property to be updated. serdePropKey option is valid only with updateLocation option.");
        .Option serdePropKey = .OptionBuilder.create((String)"serdePropKey");
        .OptionBuilder.withArgName((String)"table-prop-key");
        .OptionBuilder.hasArg();
        .OptionBuilder.withValueSeparator();
        .OptionBuilder.withDescription((String)"Specify the key for table property to be updated. tablePropKey option is valid only with updateLocation option.");
        .Option tablePropKey = .OptionBuilder.create((String)"tablePropKey");
        .OptionBuilder.withArgName((String)"find-compactions");
        .OptionBuilder.hasOptionalArg();
        .OptionBuilder.withDescription((String)"Generates a set Compaction commands to run to prepare for Hive 2.x to 3.0 upgrade");
        .Option prepareAcidUpgrade = .OptionBuilder.create((String)"prepareAcidUpgrade");
        this.cmdLineOptions.addOption(help);
        this.cmdLineOptions.addOption(listFSRoot);
        this.cmdLineOptions.addOption(executeJDOQL);
        this.cmdLineOptions.addOption(updateFSRootLoc);
        this.cmdLineOptions.addOption(dryRun);
        this.cmdLineOptions.addOption(serdePropKey);
        this.cmdLineOptions.addOption(tablePropKey);
        this.cmdLineOptions.addOption(prepareAcidUpgrade);
    }

    private void initObjectStore(Configuration conf) {
        if (!this.isObjStoreInitialized) {
            this.objStore = new ObjectStore();
            this.objStore.setConf(conf);
            this.isObjStoreInitialized = true;
        }
    }

    private void shutdownObjectStore() {
        if (this.isObjStoreInitialized) {
            this.objStore.shutdown();
            this.isObjStoreInitialized = false;
        }
    }

    private void listFSRoot() {
        Configuration conf = MetastoreConf.newMetastoreConf();
        this.initObjectStore(conf);
        Set<String> hdfsRoots = this.objStore.listFSRoots();
        if (hdfsRoots != null) {
            System.out.println("Listing FS Roots..");
            for (String s : hdfsRoots) {
                System.out.println(s);
            }
        } else {
            System.err.println("Encountered error during listFSRoot - commit of JDO transaction failed");
        }
    }

    private void executeJDOQLSelect(String query) {
        Configuration conf = MetastoreConf.newMetastoreConf();
        this.initObjectStore(conf);
        System.out.println("Executing query: " + query);
        try (ObjectStore.QueryWrapper queryWrapper = new ObjectStore.QueryWrapper();){
            Collection<?> result = this.objStore.executeJDOQLSelect(query, queryWrapper);
            if (result != null) {
                for (Object o : result) {
                    System.out.println(o.toString());
                }
            } else {
                System.err.println("Encountered error during executeJDOQLSelect -commit of JDO transaction failed.");
            }
        }
    }

    private void executeJDOQLUpdate(String query) {
        Configuration conf = MetastoreConf.newMetastoreConf();
        this.initObjectStore(conf);
        System.out.println("Executing query: " + query);
        long numUpdated = this.objStore.executeJDOQLUpdate(query);
        if (numUpdated >= 0L) {
            System.out.println("Number of records updated: " + numUpdated);
        } else {
            System.err.println("Encountered error during executeJDOQL -commit of JDO transaction failed.");
        }
    }

    private int printUpdateLocations(Map<String, String> updateLocations) {
        int count = 0;
        for (String key : updateLocations.keySet()) {
            String value = updateLocations.get(key);
            System.out.println("old location: " + key + " new location: " + value);
            ++count;
        }
        return count;
    }

    private void printTblURIUpdateSummary(ObjectStore.UpdateMStorageDescriptorTblURIRetVal retVal, boolean isDryRun) {
        String tblName = "SDS";
        String fieldName = "LOCATION";
        if (retVal == null) {
            System.err.println("Encountered error while executing updateMStorageDescriptorTblURI - commit of JDO transaction failed. Failed to update FSRoot locations in " + fieldName + "field in " + tblName + " table.");
        } else {
            int numNullRecords;
            Map<String, String> updateLocations = retVal.getUpdateLocations();
            if (isDryRun) {
                System.out.println("Dry Run of updateLocation on table " + tblName + "..");
            } else {
                System.out.println("Successfully updated the following locations..");
            }
            int count = this.printUpdateLocations(updateLocations);
            if (isDryRun) {
                System.out.println("Found " + count + " records in " + tblName + " table to update");
            } else {
                System.out.println("Updated " + count + " records in " + tblName + " table");
            }
            List<String> badRecords = retVal.getBadRecords();
            if (badRecords.size() > 0) {
                System.err.println("Warning: Found records with bad " + fieldName + " in " + tblName + " table.. ");
                for (String badRecord : badRecords) {
                    System.err.println("bad location URI: " + badRecord);
                }
            }
            if ((numNullRecords = retVal.getNumNullRecords()) != 0) {
                LOG.debug("Number of NULL location URI: " + numNullRecords + ". This can happen for View or Index.");
            }
        }
    }

    private void printDatabaseURIUpdateSummary(ObjectStore.UpdateMDatabaseURIRetVal retVal, boolean isDryRun) {
        String tblName = "DBS";
        String fieldName = "LOCATION_URI";
        if (retVal == null) {
            System.err.println("Encountered error while executing updateMDatabaseURI - commit of JDO transaction failed. Failed to update FSRoot locations in " + fieldName + "field in " + tblName + " table.");
        } else {
            Map<String, String> updateLocations = retVal.getUpdateLocations();
            if (isDryRun) {
                System.out.println("Dry Run of updateLocation on table " + tblName + "..");
            } else {
                System.out.println("Successfully updated the following locations..");
            }
            int count = this.printUpdateLocations(updateLocations);
            if (isDryRun) {
                System.out.println("Found " + count + " records in " + tblName + " table to update");
            } else {
                System.out.println("Updated " + count + " records in " + tblName + " table");
            }
            List<String> badRecords = retVal.getBadRecords();
            if (badRecords.size() > 0) {
                System.err.println("Warning: Found records with bad " + fieldName + " in " + tblName + " table.. ");
                for (String badRecord : badRecords) {
                    System.err.println("bad location URI: " + badRecord);
                }
            }
        }
    }

    private void printPropURIUpdateSummary(ObjectStore.UpdatePropURIRetVal retVal, String tablePropKey, boolean isDryRun, String tblName, String methodName) {
        if (retVal == null) {
            System.err.println("Encountered error while executing " + methodName + " - commit of JDO transaction failed. Failed to update FSRoot locations in value field corresponding to" + tablePropKey + " in " + tblName + " table.");
        } else {
            Map<String, String> updateLocations = retVal.getUpdateLocations();
            if (isDryRun) {
                System.out.println("Dry Run of updateLocation on table " + tblName + "..");
            } else {
                System.out.println("Successfully updated the following locations..");
            }
            int count = this.printUpdateLocations(updateLocations);
            if (isDryRun) {
                System.out.println("Found " + count + " records in " + tblName + " table to update");
            } else {
                System.out.println("Updated " + count + " records in " + tblName + " table");
            }
            List<String> badRecords = retVal.getBadRecords();
            if (badRecords.size() > 0) {
                System.err.println("Warning: Found records with bad " + tablePropKey + " key in " + tblName + " table.. ");
                for (String badRecord : badRecords) {
                    System.err.println("bad location URI: " + badRecord);
                }
            }
        }
    }

    private void printSerdePropURIUpdateSummary(ObjectStore.UpdateSerdeURIRetVal retVal, String serdePropKey, boolean isDryRun) {
        String tblName = "SERDE_PARAMS";
        if (retVal == null) {
            System.err.println("Encountered error while executing updateSerdeURI - commit of JDO transaction failed. Failed to update FSRoot locations in value field corresponding to " + serdePropKey + " in " + tblName + " table.");
        } else {
            Map<String, String> updateLocations = retVal.getUpdateLocations();
            if (isDryRun) {
                System.out.println("Dry Run of updateLocation on table " + tblName + "..");
            } else {
                System.out.println("Successfully updated the following locations..");
            }
            int count = this.printUpdateLocations(updateLocations);
            if (isDryRun) {
                System.out.println("Found " + count + " records in " + tblName + " table to update");
            } else {
                System.out.println("Updated " + count + " records in " + tblName + " table");
            }
            List<String> badRecords = retVal.getBadRecords();
            if (badRecords.size() > 0) {
                System.err.println("Warning: Found records with bad " + serdePropKey + " key in " + tblName + " table.. ");
                for (String badRecord : badRecords) {
                    System.err.println("bad location URI: " + badRecord);
                }
            }
        }
    }

    public void updateFSRootLocation(URI oldURI, URI newURI, String serdePropKey, String tablePropKey, boolean isDryRun) {
        Configuration conf = MetastoreConf.newMetastoreConf();
        this.initObjectStore(conf);
        System.out.println("Looking for LOCATION_URI field in DBS table to update..");
        ObjectStore.UpdateMDatabaseURIRetVal updateMDBURIRetVal = this.objStore.updateMDatabaseURI(oldURI, newURI, isDryRun);
        this.printDatabaseURIUpdateSummary(updateMDBURIRetVal, isDryRun);
        System.out.println("Looking for LOCATION field in SDS table to update..");
        ObjectStore.UpdateMStorageDescriptorTblURIRetVal updateTblURIRetVal = this.objStore.updateMStorageDescriptorTblURI(oldURI, newURI, isDryRun);
        this.printTblURIUpdateSummary(updateTblURIRetVal, isDryRun);
        if (tablePropKey != null) {
            System.out.println("Looking for value of " + tablePropKey + " key in TABLE_PARAMS table to update..");
            ObjectStore.UpdatePropURIRetVal updateTblPropURIRetVal = this.objStore.updateTblPropURI(oldURI, newURI, tablePropKey, isDryRun);
            this.printPropURIUpdateSummary(updateTblPropURIRetVal, tablePropKey, isDryRun, "TABLE_PARAMS", "updateTblPropURI");
            System.out.println("Looking for value of " + tablePropKey + " key in SD_PARAMS table to update..");
            ObjectStore.UpdatePropURIRetVal updatePropURIRetVal = this.objStore.updateMStorageDescriptorTblPropURI(oldURI, newURI, tablePropKey, isDryRun);
            this.printPropURIUpdateSummary(updatePropURIRetVal, tablePropKey, isDryRun, "SD_PARAMS", "updateMStorageDescriptorTblPropURI");
        }
        if (serdePropKey != null) {
            System.out.println("Looking for value of " + serdePropKey + " key in SERDE_PARAMS table to update..");
            ObjectStore.UpdateSerdeURIRetVal updateSerdeURIretVal = this.objStore.updateSerdeURI(oldURI, newURI, serdePropKey, isDryRun);
            this.printSerdePropURIUpdateSummary(updateSerdeURIretVal, serdePropKey, isDryRun);
        }
    }

    private void prepareAcidUpgrade(String scriptLocation) {
        try {
            this.prepareAcidUpgradeInternal(scriptLocation);
        }
        catch (IOException | TException ex) {
            System.err.println(StringUtils.stringifyException(ex));
            HiveMetaTool.printAndExit(this);
        }
    }

    private void prepareAcidUpgradeInternal(String scriptLocation) throws MetaException, TException, IOException {
        Configuration conf = MetastoreConf.newMetastoreConf();
        System.out.println("Looking for Acid tables that need to be compacted");
        HiveMetaStoreClient hms = new HiveMetaStoreClient(conf);
        List<String> databases = hms.getAllDatabases();
        System.out.println("Found " + databases.size() + " databases to process");
        ArrayList<String> compactions = new ArrayList<String>();
        ArrayList<String> convertToAcid = new ArrayList<String>();
        ArrayList<String> convertToMM = new ArrayList<String>();
        CompactionMetaInfo compactionMetaInfo = new CompactionMetaInfo();
        for (String dbName : databases) {
            List<String> tables = hms.getAllTables(dbName);
            System.out.println("found " + tables.size() + " tables in " + dbName);
            for (String tableName : tables) {
                Table t = hms.getTable(dbName, tableName);
                List<String> compactionCommands = HiveMetaTool.getCompactionCommands(t, conf, hms, compactionMetaInfo);
                compactions.addAll(compactionCommands);
                HiveMetaTool.processConversion(t, convertToAcid, convertToMM, hms);
            }
        }
        HiveMetaTool.makeCompactionScript(compactions, scriptLocation, compactionMetaInfo);
        HiveMetaTool.makeConvertTableScript(convertToAcid, convertToMM, scriptLocation);
        HiveMetaTool.makeRenameFileScript(scriptLocation);
    }

    private static void processConversion(Table t, List<String> convertToAcid, List<String> convertToMM, HiveMetaStoreClient hms) throws TException {
        if (HiveMetaTool.isFullAcidTable(t)) {
            return;
        }
        if (!TableType.MANAGED_TABLE.name().equalsIgnoreCase(t.getTableType())) {
            return;
        }
        String fullTableName = Warehouse.getQualifiedName(t);
        if (t.getPartitionKeysSize() <= 0) {
            if (HiveMetaTool.canBeMadeAcid(fullTableName, t.getSd())) {
                convertToAcid.add("ALTER TABLE " + Warehouse.getQualifiedName(t) + " SET TBLPROPERTIES ('transactional'='true')");
            } else {
                convertToMM.add("ALTER TABLE " + Warehouse.getQualifiedName(t) + " SET TBLPROPERTIES ('transactional'='true', 'transactional_properties'='insert_only')");
            }
        } else {
            List<String> partNames = hms.listPartitionNames(t.getDbName(), t.getTableName(), (short)-1);
            int batchSize = 10000;
            int numWholeBatches = partNames.size() / batchSize;
            for (int i = 0; i < numWholeBatches; ++i) {
                List<Partition> partitionList = hms.getPartitionsByNames(t.getDbName(), t.getTableName(), partNames.subList(i * batchSize, (i + 1) * batchSize));
                for (Partition p : partitionList) {
                    if (HiveMetaTool.canBeMadeAcid(fullTableName, p.getSd())) continue;
                    convertToMM.add("ALTER TABLE " + Warehouse.getQualifiedName(t) + " SET TBLPROPERTIES ('transactional'='true', 'transactional_properties'='insert_only')");
                    return;
                }
            }
            if (numWholeBatches * batchSize < partNames.size()) {
                List<Partition> partitionList = hms.getPartitionsByNames(t.getDbName(), t.getTableName(), partNames.subList(numWholeBatches * batchSize, partNames.size()));
                for (Partition p : partitionList) {
                    if (HiveMetaTool.canBeMadeAcid(fullTableName, p.getSd())) continue;
                    convertToMM.add("ALTER TABLE " + Warehouse.getQualifiedName(t) + " SET TBLPROPERTIES ('transactional'='true', 'transactional_properties'='insert_only')");
                    return;
                }
            }
            convertToAcid.add("ALTER TABLE " + Warehouse.getQualifiedName(t) + " SET TBLPROPERTIES ('transactional'='true')");
        }
    }

    private static boolean canBeMadeAcid(String fullTableName, StorageDescriptor sd) {
        return HiveMetaTool.isAcidInputOutputFormat(fullTableName, sd) && sd.getSortColsSize() <= 0;
    }

    private static boolean isAcidInputOutputFormat(String fullTableName, StorageDescriptor sd) {
        try {
            Class<?> outputFormatClass;
            Class<?> inputFormatClass = sd.getInputFormat() == null ? null : Class.forName(sd.getInputFormat());
            Class<?> clazz = outputFormatClass = sd.getOutputFormat() == null ? null : Class.forName(sd.getOutputFormat());
            if (inputFormatClass != null && outputFormatClass != null && Class.forName("org.apache.hadoop.hive.ql.io.AcidInputFormat").isAssignableFrom(inputFormatClass) && Class.forName("org.apache.hadoop.hive.ql.io.AcidOutputFormat").isAssignableFrom(outputFormatClass)) {
                return true;
            }
        }
        catch (ClassNotFoundException e) {
            System.err.println("Could not determine if " + fullTableName + " can be made Acid due to: " + e.getMessage());
            return false;
        }
        return false;
    }

    private static void makeCompactionScript(List<String> commands, String scriptLocation, CompactionMetaInfo compactionMetaInfo) throws IOException {
        if (commands.isEmpty()) {
            System.out.println("No compaction is necessary");
            return;
        }
        String fileName = "compacts_" + System.currentTimeMillis() + ".sql";
        System.out.println("Writing compaction commands to " + fileName);
        try (PrintWriter pw = HiveMetaTool.createScript(commands, fileName, scriptLocation);){
            pw.println("-- Generated total of " + commands.size() + " compaction commands");
            if ((double)compactionMetaInfo.numberOfBytes < Math.pow(2.0, 20.0)) {
                pw.println("-- The total volume of data to be compacted is " + String.format("%.6fMB", (double)compactionMetaInfo.numberOfBytes / Math.pow(2.0, 20.0)));
            } else {
                pw.println("-- The total volume of data to be compacted is " + String.format("%.3fGB", (double)compactionMetaInfo.numberOfBytes / Math.pow(2.0, 30.0)));
            }
            pw.println();
            pw.println("-- Please note that compaction may be a heavyweight and time consuming process.\n-- Submitting all of these commands will enqueue them to a scheduling queue from\n-- which they will be picked up by compactor Workers.  The max number of\n-- concurrent Workers is controlled by hive.compactor.worker.threads configured\n-- for the standalone metastore process.  Compaction itself is a Map-Reduce job\n-- which is submitted to the YARN queue identified by hive.compactor.job.queue\n-- property if defined or 'default' if not defined.  It's advisable to set the\n-- capacity of this queue appropriately");
        }
    }

    private static void makeConvertTableScript(List<String> alterTableAcid, List<String> alterTableMm, String scriptLocation) throws IOException {
        Throwable throwable;
        PrintWriter pw;
        String fileName;
        if (alterTableAcid.isEmpty()) {
            System.out.println("No acid conversion is necessary");
        } else {
            fileName = "convertToAcid_" + System.currentTimeMillis() + ".sql";
            System.out.println("Writing acid conversion commands to " + fileName);
            pw = HiveMetaTool.createScript(alterTableAcid, fileName, scriptLocation);
            throwable = null;
            try {
                pw.println("-- These commands may be executed by Hive 1.x later");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (pw != null) {
                    if (throwable != null) {
                        try {
                            pw.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        pw.close();
                    }
                }
            }
        }
        if (alterTableMm.isEmpty()) {
            System.out.println("No managed table conversion is necessary");
        } else {
            fileName = "convertToMM_" + System.currentTimeMillis() + ".sql";
            System.out.println("Writing managed table conversion commands to " + fileName);
            pw = HiveMetaTool.createScript(alterTableMm, fileName, scriptLocation);
            throwable = null;
            try {
                pw.println("-- These commands must be executed by Hive 3.0 or later");
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (pw != null) {
                    if (throwable != null) {
                        try {
                            pw.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        pw.close();
                    }
                }
            }
        }
    }

    private static PrintWriter createScript(List<String> commands, String fileName, String scriptLocation) throws IOException {
        FileWriter fw = new FileWriter(scriptLocation + "/" + fileName);
        PrintWriter pw = new PrintWriter(fw);
        for (String cmd : commands) {
            pw.println(cmd + ";");
        }
        return pw;
    }

    private static void makeRenameFileScript(String scriptLocation) throws IOException {
        List<String> commands = Collections.emptyList();
        if (commands.isEmpty()) {
            System.out.println("No file renaming is necessary");
        } else {
            String fileName = "normalizeFileNames_" + System.currentTimeMillis() + ".sh";
            System.out.println("Writing file renaming commands to " + fileName);
            PrintWriter pw = HiveMetaTool.createScript(commands, fileName, scriptLocation);
            pw.close();
        }
    }

    private static List<String> getCompactionCommands(Table t, Configuration conf, HiveMetaStoreClient hms, CompactionMetaInfo compactionMetaInfo) throws IOException, TException {
        if (!HiveMetaTool.isFullAcidTable(t)) {
            return Collections.emptyList();
        }
        if (t.getPartitionKeysSize() <= 0) {
            if (!HiveMetaTool.needsCompaction(new Path(t.getSd().getLocation()), conf, compactionMetaInfo)) {
                return Collections.emptyList();
            }
            ArrayList<String> cmds = new ArrayList<String>();
            cmds.add(HiveMetaTool.getCompactionCommand(t, null));
            return cmds;
        }
        List<String> partNames = hms.listPartitionNames(t.getDbName(), t.getTableName(), (short)-1);
        int batchSize = 10000;
        int numWholeBatches = partNames.size() / batchSize;
        ArrayList<String> compactionCommands = new ArrayList<String>();
        for (int i = 0; i < numWholeBatches; ++i) {
            List<Partition> partitionList = hms.getPartitionsByNames(t.getDbName(), t.getTableName(), partNames.subList(i * batchSize, (i + 1) * batchSize));
            for (Partition p : partitionList) {
                if (!HiveMetaTool.needsCompaction(new Path(p.getSd().getLocation()), conf, compactionMetaInfo)) continue;
                compactionCommands.add(HiveMetaTool.getCompactionCommand(t, p));
            }
        }
        if (numWholeBatches * batchSize < partNames.size()) {
            List<Partition> partitionList = hms.getPartitionsByNames(t.getDbName(), t.getTableName(), partNames.subList(numWholeBatches * batchSize, partNames.size()));
            for (Partition p : partitionList) {
                if (!HiveMetaTool.needsCompaction(new Path(p.getSd().getLocation()), conf, compactionMetaInfo)) continue;
                compactionCommands.add(HiveMetaTool.getCompactionCommand(t, p));
            }
        }
        return compactionCommands;
    }

    private static boolean needsCompaction(Path location, Configuration conf, CompactionMetaInfo compactionMetaInfo) throws IOException {
        FileSystem fs = location.getFileSystem(conf);
        FileStatus[] deltas = fs.listStatus(location, new PathFilter(){

            public boolean accept(Path path) {
                return path.getName().startsWith("delta_") || path.getName().startsWith("delete_delta_");
            }
        });
        if (deltas == null || deltas.length == 0) {
            return false;
        }
        for (FileStatus delta : deltas) {
            FileStatus[] buckets;
            if (!delta.isDirectory()) continue;
            for (FileStatus bucket : buckets = fs.listStatus(delta.getPath(), new PathFilter(){

                public boolean accept(Path path) {
                    return path.getName().startsWith("bucket_");
                }
            })) {
                if (bucket.getPath().getName().endsWith("_flush_length")) break;
                if (!HiveMetaTool.needsCompaction(bucket, fs)) continue;
                compactionMetaInfo.numberOfBytes += HiveMetaTool.getDataSize(location, conf);
                return true;
            }
        }
        return false;
    }

    private static long getDataSize(Path location, Configuration conf) throws IOException {
        FileSystem fs = location.getFileSystem(conf);
        ContentSummary cs = fs.getContentSummary(location);
        return cs.getLength();
    }

    private static boolean needsCompaction(FileStatus bucket, FileSystem fs) throws IOException {
        Reader orcReader = OrcFile.createReader(bucket.getPath(), OrcFile.readerOptions(fs.getConf()).filesystem(fs));
        AcidStats as = OrcAcidUtils.parseAcidStats(orcReader);
        if (as == null) {
            throw new IllegalStateException("AcidStats missing in " + bucket.getPath());
        }
        return as.deletes > 0L || as.updates > 0L;
    }

    private static String getCompactionCommand(Table t, Partition p) {
        StringBuilder sb = new StringBuilder("ALTER TABLE ").append(Warehouse.getQualifiedName(t));
        if (t.getPartitionKeysSize() > 0) {
            assert (p != null) : "must supply partition for partitioned table " + Warehouse.getQualifiedName(t);
            sb.append(" PARTITION(");
            for (int i = 0; i < t.getPartitionKeysSize(); ++i) {
                sb.append(t.getPartitionKeys().get(i).getName()).append('=').append(p.getValues().get(i)).append(",");
            }
            sb.setCharAt(sb.length() - 1, ')');
        }
        return sb.append(" COMPACT 'major'").toString();
    }

    private static boolean isFullAcidTable(Table t) {
        if (t.getParametersSize() <= 0) {
            return false;
        }
        String transacationalValue = t.getParameters().get("transactional");
        if (transacationalValue != null && "true".equalsIgnoreCase(transacationalValue)) {
            System.out.println("Found Acid table: " + Warehouse.getQualifiedName(t));
            return true;
        }
        return false;
    }

    private static void printAndExit(HiveMetaTool metaTool) {
        .HelpFormatter formatter = new .HelpFormatter();
        formatter.printHelp("metatool", metaTool.cmdLineOptions);
        System.exit(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        HiveMetaTool metaTool = new HiveMetaTool();
        metaTool.init();
        .GnuParser parser = new .GnuParser();
        .CommandLine line = null;
        try {
            try {
                line = parser.parse(metaTool.cmdLineOptions, args);
            }
            catch (.ParseException e) {
                System.err.println("HiveMetaTool:Parsing failed.  Reason: " + e.getLocalizedMessage());
                HiveMetaTool.printAndExit(metaTool);
            }
            if (line.hasOption("help")) {
                .HelpFormatter formatter = new .HelpFormatter();
                formatter.printHelp("metatool", metaTool.cmdLineOptions);
            } else if (line.hasOption("listFSRoot")) {
                if (line.hasOption("dryRun")) {
                    System.err.println("HiveMetaTool: dryRun is not valid with listFSRoot");
                    HiveMetaTool.printAndExit(metaTool);
                } else if (line.hasOption("serdePropKey")) {
                    System.err.println("HiveMetaTool: serdePropKey is not valid with listFSRoot");
                    HiveMetaTool.printAndExit(metaTool);
                } else if (line.hasOption("tablePropKey")) {
                    System.err.println("HiveMetaTool: tablePropKey is not valid with listFSRoot");
                    HiveMetaTool.printAndExit(metaTool);
                }
                metaTool.listFSRoot();
            } else if (line.hasOption("executeJDOQL")) {
                String query = line.getOptionValue("executeJDOQL");
                if (line.hasOption("dryRun")) {
                    System.err.println("HiveMetaTool: dryRun is not valid with executeJDOQL");
                    HiveMetaTool.printAndExit(metaTool);
                } else if (line.hasOption("serdePropKey")) {
                    System.err.println("HiveMetaTool: serdePropKey is not valid with executeJDOQL");
                    HiveMetaTool.printAndExit(metaTool);
                } else if (line.hasOption("tablePropKey")) {
                    System.err.println("HiveMetaTool: tablePropKey is not valid with executeJDOQL");
                    HiveMetaTool.printAndExit(metaTool);
                }
                if (query.toLowerCase().trim().startsWith("select")) {
                    metaTool.executeJDOQLSelect(query);
                } else if (query.toLowerCase().trim().startsWith("update")) {
                    metaTool.executeJDOQLUpdate(query);
                } else {
                    System.err.println("HiveMetaTool:Unsupported statement type");
                    HiveMetaTool.printAndExit(metaTool);
                }
            } else if (line.hasOption("updateLocation")) {
                String[] loc = line.getOptionValues("updateLocation");
                boolean isDryRun = false;
                String serdepropKey = null;
                String tablePropKey = null;
                if (loc.length != 2 && loc.length != 3) {
                    System.err.println("HiveMetaTool:updateLocation takes in 2 required and 1 optional arguments but was passed " + loc.length + " arguments");
                    HiveMetaTool.printAndExit(metaTool);
                }
                Path newPath = new Path(loc[0]);
                Path oldPath = new Path(loc[1]);
                URI oldURI = oldPath.toUri();
                URI newURI = newPath.toUri();
                if (line.hasOption("dryRun")) {
                    isDryRun = true;
                }
                if (line.hasOption("serdePropKey")) {
                    serdepropKey = line.getOptionValue("serdePropKey");
                }
                if (line.hasOption("tablePropKey")) {
                    tablePropKey = line.getOptionValue("tablePropKey");
                }
                if (oldURI.getHost() == null || newURI.getHost() == null) {
                    System.err.println("HiveMetaTool:A valid host is required in both old-loc and new-loc");
                } else if (oldURI.getScheme() == null || newURI.getScheme() == null) {
                    System.err.println("HiveMetaTool:A valid scheme is required in both old-loc and new-loc");
                } else {
                    metaTool.updateFSRootLocation(oldURI, newURI, serdepropKey, tablePropKey, isDryRun);
                }
            } else if (line.hasOption("prepareAcidUpgrade")) {
                String[] values = line.getOptionValues("prepareAcidUpgrade");
                String targetDir = ".";
                if (values != null && values.length > 0) {
                    if (values.length > 1) {
                        System.err.println("HiveMetaTool: prepareAcidUpgrade");
                        HiveMetaTool.printAndExit(metaTool);
                    } else {
                        targetDir = values[0];
                    }
                }
                metaTool.prepareAcidUpgrade(targetDir);
            } else {
                if (line.hasOption("dryRun")) {
                    System.err.println("HiveMetaTool: dryRun is not a valid standalone option");
                } else if (line.hasOption("serdePropKey")) {
                    System.err.println("HiveMetaTool: serdePropKey is not a valid standalone option");
                } else if (line.hasOption("tablePropKey")) {
                    System.err.println("HiveMetaTool: tablePropKey is not a valid standalone option");
                    HiveMetaTool.printAndExit(metaTool);
                } else {
                    System.err.print("HiveMetaTool:Parsing failed.  Reason: Invalid arguments: ");
                    for (String s : line.getArgs()) {
                        System.err.print(s + " ");
                    }
                    System.err.println();
                }
                HiveMetaTool.printAndExit(metaTool);
            }
        }
        finally {
            metaTool.shutdownObjectStore();
        }
    }

    private static class CompactionMetaInfo {
        long numberOfBytes;

        private CompactionMetaInfo() {
        }
    }
}

