/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import com.esotericsoftware.kryo.KryoException;
import com.facebook.presto.hive.$internal.com.google.common.annotations.VisibleForTesting;
import com.facebook.presto.hive.$internal.org.apache.commons.lang3.tuple.ImmutablePair;
import com.facebook.presto.hive.$internal.org.apache.commons.lang3.tuple.Pair;
import com.facebook.presto.hive.$internal.org.slf4j.Logger;
import com.facebook.presto.hive.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.ObjectPair;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.HashTableLoaderFactory;
import org.apache.hadoop.hive.ql.exec.AbstractMapJoinOperator;
import org.apache.hadoop.hive.ql.exec.HashTableLoader;
import org.apache.hadoop.hive.ql.exec.JoinUtil;
import org.apache.hadoop.hive.ql.exec.MapredContext;
import org.apache.hadoop.hive.ql.exec.ObjectCache;
import org.apache.hadoop.hive.ql.exec.ObjectCacheFactory;
import org.apache.hadoop.hive.ql.exec.mr.ExecMapperContext;
import org.apache.hadoop.hive.ql.exec.persistence.BytesBytesMultiHashMap;
import org.apache.hadoop.hive.ql.exec.persistence.HybridHashTableContainer;
import org.apache.hadoop.hive.ql.exec.persistence.KeyValueContainer;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinBytesTableContainer;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinKey;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinObjectSerDeContext;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinRowContainer;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinTableContainer;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinTableContainerSerDe;
import org.apache.hadoop.hive.ql.exec.persistence.ObjectContainer;
import org.apache.hadoop.hive.ql.exec.persistence.UnwrapRowContainer;
import org.apache.hadoop.hive.ql.exec.spark.SparkUtilities;
import org.apache.hadoop.hive.ql.exec.tez.LlapObjectCache;
import org.apache.hadoop.hive.ql.exec.tez.LlapObjectSubCache;
import org.apache.hadoop.hive.ql.io.HiveKey;
import org.apache.hadoop.hive.ql.log.PerfLogger;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.JoinCondDesc;
import org.apache.hadoop.hive.ql.plan.MapJoinDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.plan.api.OperatorType;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeUtils;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hive.common.util.ReflectionUtil;

public class MapJoinOperator
extends AbstractMapJoinOperator<MapJoinDesc>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(MapJoinOperator.class.getName());
    private static final String CLASS_NAME = MapJoinOperator.class.getName();
    private final transient PerfLogger perfLogger = SessionState.getPerfLogger();
    private transient String cacheKey;
    private transient ObjectCache cache;
    protected HashTableLoader loader;
    protected transient MapJoinTableContainer[] mapJoinTables;
    private transient MapJoinTableContainerSerDe[] mapJoinTableSerdes;
    private transient boolean hashTblInitedOnce;
    protected transient MapJoinTableContainer.ReusableGetAdaptor[] hashMapRowGetters;
    private UnwrapRowContainer[] unwrapContainer;
    private transient Configuration hconf;
    private transient boolean hybridMapJoinLeftover;
    protected transient MapJoinBytesTableContainer[] spilledMapJoinTables;
    protected HybridHashTableContainer firstSmallTable;
    protected transient boolean isTestingNoHashTableLoad;
    private transient int numBuckets = -1;
    private transient int bucketId = -1;
    private transient ReentrantLock subCacheLock = new ReentrantLock();

    protected MapJoinOperator() {
    }

    public MapJoinOperator(CompilationOpContext ctx) {
        super(ctx);
    }

    public MapJoinOperator(AbstractMapJoinOperator<? extends MapJoinDesc> mjop) {
        super(mjop);
    }

    @Override
    public void endGroup() throws HiveException {
        this.defaultEndGroup();
    }

    @Override
    public void startGroup() throws HiveException {
        this.defaultStartGroup();
    }

    protected HashTableLoader getHashTableLoader(Configuration hconf) {
        return HashTableLoaderFactory.getLoader(hconf);
    }

    public String getCacheKey() {
        return this.cacheKey;
    }

    @Override
    protected void initializeOp(Configuration hconf) throws HiveException {
        this.hconf = hconf;
        this.unwrapContainer = new UnwrapRowContainer[((MapJoinDesc)this.conf).getTagLength()];
        super.initializeOp(hconf);
        int tagLen = ((MapJoinDesc)this.conf).getTagLength();
        String queryId = HiveConf.getVar(hconf, HiveConf.ConfVars.HIVEQUERYID);
        this.cacheKey = "HASH_MAP_" + this.getOperatorId() + "_container";
        this.cache = ObjectCacheFactory.getCache(hconf, queryId, false);
        this.loader = this.getHashTableLoader(hconf);
        this.bucketId = hconf.getInt("llap.bucket.id", -1);
        this.numBuckets = hconf.getInt("llap.num.buckets", -1);
        this.hashMapRowGetters = null;
        this.mapJoinTables = new MapJoinTableContainer[tagLen];
        this.mapJoinTableSerdes = new MapJoinTableContainerSerDe[tagLen];
        this.hashTblInitedOnce = false;
        this.hybridMapJoinLeftover = false;
        this.firstSmallTable = null;
        this.generateMapMetaData();
        this.isTestingNoHashTableLoad = HiveConf.getBoolVar(hconf, HiveConf.ConfVars.HIVE_MAPJOIN_TESTING_NO_HASH_TABLE_LOAD);
        if (this.isTestingNoHashTableLoad) {
            return;
        }
        ExecMapperContext mapContext = this.getExecContext();
        MapredContext mrContext = MapredContext.get();
        if (!((MapJoinDesc)this.conf).isBucketMapJoin() && !((MapJoinDesc)this.conf).isDynamicPartitionHashJoin()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("This is not bucket map join, so cache");
            }
            Future<Pair> future = this.cache.retrieveAsync(this.cacheKey, () -> this.loadHashTable(mapContext, mrContext));
            this.asyncInitOperations.add(future);
        } else if (!this.isInputFileChangeSensitive(mapContext)) {
            this.loadHashTable(mapContext, mrContext);
            this.hashTblInitedOnce = true;
        }
    }

    @Override
    protected void completeInitializationOp(Object[] os) throws HiveException {
        if (os.length != 0) {
            Pair pair = (Pair)os[0];
            boolean spilled = false;
            for (MapJoinTableContainer container : (MapJoinTableContainer[])pair.getLeft()) {
                if (container == null) continue;
                spilled = spilled || container.hasSpill();
            }
            if (spilled) {
                this.loadHashTable(this.getExecContext(), MapredContext.get());
            } else {
                if (LOG.isDebugEnabled()) {
                    String s = "Using tables from cache: [";
                    for (MapJoinTableContainer c : (MapJoinTableContainer[])pair.getLeft()) {
                        s = s + (c == null ? "null" : c.getClass().getSimpleName()) + ", ";
                    }
                    LOG.debug(s + "]");
                }
                this.mapJoinTables = (MapJoinTableContainer[])pair.getLeft();
                this.mapJoinTableSerdes = (MapJoinTableContainerSerDe[])pair.getRight();
            }
            this.hashTblInitedOnce = true;
        }
        if (this.getExecContext() != null) {
            this.getExecContext().setLastInputPath(null);
            this.getExecContext().setCurrentInputPath(null);
        }
    }

    @VisibleForTesting
    public void setTestMapJoinTableContainer(int posSmallTable, MapJoinTableContainer testMapJoinTableContainer, MapJoinTableContainerSerDe mapJoinTableContainerSerDe) {
        this.mapJoinTables[posSmallTable] = testMapJoinTableContainer;
        this.mapJoinTableSerdes[posSmallTable] = mapJoinTableContainerSerDe;
    }

    @Override
    protected List<ObjectInspector> getValueObjectInspectors(byte alias, List<ObjectInspector>[] aliasToObjectInspectors) {
        int[] valueIndex = ((MapJoinDesc)this.conf).getValueIndex(alias);
        if (valueIndex == null) {
            return super.getValueObjectInspectors(alias, aliasToObjectInspectors);
        }
        List<ObjectInspector> inspectors = aliasToObjectInspectors[alias];
        int bigPos = ((MapJoinDesc)this.conf).getPosBigTable();
        ObjectInspectorConverters.Converter[] converters = new ObjectInspectorConverters.Converter[valueIndex.length];
        ArrayList<ObjectInspector> valueOI = new ArrayList<ObjectInspector>();
        for (int i = 0; i < valueIndex.length; ++i) {
            if (valueIndex[i] >= 0 && !this.joinKeysObjectInspectors[bigPos].isEmpty()) {
                if (((MapJoinDesc)this.conf).getNoOuterJoin()) {
                    valueOI.add((ObjectInspector)this.joinKeysObjectInspectors[bigPos].get(valueIndex[i]));
                    continue;
                }
                valueOI.add(inspectors.get(i));
                converters[i] = ObjectInspectorConverters.getConverter((ObjectInspector)this.joinKeysObjectInspectors[bigPos].get(valueIndex[i]), inspectors.get(i));
                continue;
            }
            valueOI.add(inspectors.get(i));
        }
        this.unwrapContainer[alias] = new UnwrapRowContainer(alias, valueIndex, converters, this.hasFilter(alias));
        return valueOI;
    }

    public void generateMapMetaData() throws HiveException {
        try {
            TableDesc keyTableDesc = ((MapJoinDesc)this.conf).getKeyTblDesc();
            AbstractSerDe keySerializer = (AbstractSerDe)ReflectionUtil.newInstance(keyTableDesc.getDeserializerClass(), null);
            SerDeUtils.initializeSerDe(keySerializer, null, keyTableDesc.getProperties(), null);
            MapJoinObjectSerDeContext keyContext = new MapJoinObjectSerDeContext(keySerializer, false);
            for (int pos = 0; pos < this.order.length; ++pos) {
                if (pos == this.posBigTable) continue;
                TableDesc valueTableDesc = ((MapJoinDesc)this.conf).getNoOuterJoin() ? ((MapJoinDesc)this.conf).getValueTblDescs().get(pos) : ((MapJoinDesc)this.conf).getValueFilteredTblDescs().get(pos);
                AbstractSerDe valueSerDe = (AbstractSerDe)ReflectionUtil.newInstance(valueTableDesc.getDeserializerClass(), null);
                SerDeUtils.initializeSerDe(valueSerDe, null, valueTableDesc.getProperties(), null);
                MapJoinObjectSerDeContext valueContext = new MapJoinObjectSerDeContext(valueSerDe, this.hasFilter(pos));
                this.mapJoinTableSerdes[pos] = new MapJoinTableContainerSerDe(keyContext, valueContext);
            }
        }
        catch (SerDeException e) {
            throw new HiveException(e);
        }
    }

    private Pair<MapJoinTableContainer[], MapJoinTableContainerSerDe[]> loadHashTableInternal(ExecMapperContext mapContext, MapredContext mrContext) throws HiveException {
        this.perfLogger.PerfLogBegin(CLASS_NAME, "LoadHashtable");
        this.loader.init(mapContext, mrContext, this.hconf, this);
        try {
            this.loader.load(this.mapJoinTables, this.mapJoinTableSerdes);
        }
        catch (HiveException e) {
            if (LOG.isInfoEnabled()) {
                LOG.info("Exception loading hash tables. Clearing partially loaded hash table containers.");
            }
            this.clearAllTableContainers();
            throw e;
        }
        this.hashTblInitedOnce = true;
        ImmutablePair<MapJoinTableContainer[], MapJoinTableContainerSerDe[]> pair = new ImmutablePair<MapJoinTableContainer[], MapJoinTableContainerSerDe[]>(this.mapJoinTables, this.mapJoinTableSerdes);
        this.perfLogger.PerfLogEnd(CLASS_NAME, "LoadHashtable");
        if (this.canSkipJoinProcessing(mapContext)) {
            LOG.info("Skipping big table join processing for " + this.toString());
            this.setDone(true);
        }
        return pair;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Pair<MapJoinTableContainer[], MapJoinTableContainerSerDe[]> loadHashTableBMJ(ExecMapperContext mapContext, MapredContext mrContext) throws HiveException {
        LlapObjectSubCache<Pair<MapJoinTableContainer[], MapJoinTableContainerSerDe[]>> subCache = new LlapObjectSubCache<Pair<MapJoinTableContainer[], MapJoinTableContainerSerDe[]>>(this.cache, this.cacheKey + "_BMJ", this.numBuckets);
        subCache.lock(this.bucketId);
        try {
            Pair<MapJoinTableContainer[], MapJoinTableContainerSerDe[]> pair = (Pair<MapJoinTableContainer[], MapJoinTableContainerSerDe[]>)subCache.get(this.bucketId);
            if (pair != null) {
                this.mapJoinTables = (MapJoinTableContainer[])pair.getLeft();
                this.mapJoinTableSerdes = pair.getRight();
                Pair<MapJoinTableContainer[], MapJoinTableContainerSerDe[]> pair2 = pair;
                return pair2;
            }
            pair = this.loadHashTableInternal(mapContext, mrContext);
            subCache.set(pair, this.bucketId);
            Pair<MapJoinTableContainer[], MapJoinTableContainerSerDe[]> pair3 = pair;
            return pair3;
        }
        finally {
            subCache.unlock(this.bucketId);
        }
    }

    protected Pair<MapJoinTableContainer[], MapJoinTableContainerSerDe[]> loadHashTable(ExecMapperContext mapContext, MapredContext mrContext) throws HiveException {
        if (this.canSkipReload(mapContext)) {
            return new ImmutablePair<MapJoinTableContainer[], MapJoinTableContainerSerDe[]>(this.mapJoinTables, this.mapJoinTableSerdes);
        }
        if (((MapJoinDesc)this.conf).isBucketMapJoin() && this.cache instanceof LlapObjectCache && this.numBuckets > 0 && HiveConf.getBoolVar(this.hconf, HiveConf.ConfVars.HIVE_TEZ_BMJ_USE_SUBCACHE)) {
            return this.loadHashTableBMJ(mapContext, mrContext);
        }
        return this.loadHashTableInternal(mapContext, mrContext);
    }

    @Override
    public void cleanUpInputFileChangedOp() throws HiveException {
        this.loadHashTable(this.getExecContext(), MapredContext.get());
    }

    protected JoinUtil.JoinResult setMapJoinKey(MapJoinTableContainer.ReusableGetAdaptor dest, Object row, byte alias) throws HiveException {
        return dest.setFromRow(row, this.joinKeys[alias], this.joinKeysObjectInspectors[alias]);
    }

    protected MapJoinKey getRefKey(byte alias) {
        for (int pos = 0; pos < this.order.length; pos = (int)((byte)(pos + 1))) {
            MapJoinKey refKey;
            if (pos == alias || (refKey = this.mapJoinTables[pos].getAnyKey()) == null) continue;
            return refKey;
        }
        return null;
    }

    @Override
    public void process(Object row, int tag) throws HiveException {
        try {
            int pos;
            int pos2;
            MapJoinKey refKey;
            this.alias = (byte)tag;
            if (this.hashMapRowGetters == null) {
                this.hashMapRowGetters = new MapJoinTableContainer.ReusableGetAdaptor[this.mapJoinTables.length];
                refKey = this.getRefKey(this.alias);
                for (pos2 = 0; pos2 < this.order.length; pos2 = (int)((byte)(pos2 + 1))) {
                    if (pos2 == this.alias) continue;
                    this.hashMapRowGetters[pos2] = this.mapJoinTables[pos2].createGetter(refKey);
                }
            }
            if (this.hybridMapJoinLeftover) {
                refKey = this.getRefKey(this.alias);
                for (pos2 = 0; pos2 < this.order.length; pos2 = (int)((byte)(pos2 + 1))) {
                    if (pos2 == this.alias || this.spilledMapJoinTables[pos2] == null) continue;
                    this.hashMapRowGetters[pos2] = this.spilledMapJoinTables[pos2].createGetter(refKey);
                }
            }
            MapJoinTableContainer.ReusableGetAdaptor firstSetKey = null;
            int fieldCount = this.joinKeys[this.alias].size();
            boolean joinNeeded = false;
            boolean bigTableRowSpilled = false;
            for (pos = 0; pos < this.order.length; pos = (int)((byte)(pos + 1))) {
                JoinUtil.JoinResult joinResult;
                MapJoinTableContainer.ReusableGetAdaptor adaptor;
                if (pos == this.alias) continue;
                if (firstSetKey == null) {
                    adaptor = firstSetKey = this.hashMapRowGetters[pos];
                    joinResult = this.setMapJoinKey(firstSetKey, row, this.alias);
                } else {
                    adaptor = this.hashMapRowGetters[pos];
                    joinResult = adaptor.setFromOther(firstSetKey);
                }
                MapJoinRowContainer rowContainer = adaptor.getCurrentRows();
                if (joinResult != JoinUtil.JoinResult.MATCH) assert (rowContainer == null || !rowContainer.hasRows()) : "Expecting an empty result set for no match";
                if (rowContainer != null && this.unwrapContainer[pos] != null) {
                    Object[] currentKey = firstSetKey.getCurrentKey();
                    rowContainer = this.unwrapContainer[pos].setInternal(rowContainer, currentKey);
                }
                if (rowContainer == null || firstSetKey.hasAnyNulls(fieldCount, this.nullsafes)) {
                    if (!this.noOuterJoin) {
                        if (!((MapJoinDesc)this.conf).isHybridHashJoin() || this.hybridMapJoinLeftover || joinResult != JoinUtil.JoinResult.SPILL && !bigTableRowSpilled) {
                            joinNeeded = true;
                            this.storage[pos] = this.dummyObjVectors[pos];
                        } else {
                            joinNeeded = false;
                        }
                    } else {
                        this.storage[pos] = this.emptyList;
                    }
                } else {
                    joinNeeded = true;
                    this.storage[pos] = rowContainer.copy();
                    this.aliasFilterTags[pos] = rowContainer.getAliasFilter();
                }
                if (joinResult != JoinUtil.JoinResult.SPILL || bigTableRowSpilled) continue;
                this.spillBigTableRow(this.mapJoinTables[pos], row);
                bigTableRowSpilled = true;
            }
            if (joinNeeded) {
                List<Object> value = this.getFilteredValue(this.alias, row);
                this.storage[this.alias].addRow(value);
                this.checkAndGenObject();
            }
            this.storage[tag].clearRows();
            for (pos = 0; pos < this.order.length; pos = (int)((byte)(pos + 1))) {
                if (pos == tag) continue;
                this.storage[pos] = null;
            }
        }
        catch (Exception e) {
            String msg = "Unexpected exception from " + this.getClass().getSimpleName() + " : " + e.getMessage();
            LOG.error(msg, e);
            throw new HiveException(msg, e);
        }
    }

    protected void spillBigTableRow(MapJoinTableContainer hybridHtContainer, Object row) throws HiveException {
        HybridHashTableContainer ht = (HybridHashTableContainer)hybridHtContainer;
        int partitionId = ht.getToSpillPartitionId();
        HybridHashTableContainer.HashPartition hp = ht.getHashPartitions()[partitionId];
        ObjectContainer bigTable = hp.getMatchfileObjContainer();
        bigTable.add(row);
    }

    @Override
    public void closeOp(boolean abort) throws HiveException {
        boolean spilled = false;
        for (MapJoinTableContainer container : this.mapJoinTables) {
            if (container == null) continue;
            spilled = spilled || container.hasSpill();
            container.dumpMetrics();
        }
        if (spilled) {
            if (!abort) {
                int pos;
                if (this.hashMapRowGetters == null) {
                    this.hashMapRowGetters = new MapJoinTableContainer.ReusableGetAdaptor[this.mapJoinTables.length];
                }
                int numPartitions = 0;
                for (pos = 0; pos < this.mapJoinTables.length; pos = (int)((byte)(pos + 1))) {
                    if (pos == ((MapJoinDesc)this.conf).getPosBigTable()) continue;
                    this.firstSmallTable = (HybridHashTableContainer)this.mapJoinTables[pos];
                    numPartitions = this.firstSmallTable.getHashPartitions().length;
                    break;
                }
                assert (numPartitions != 0) : "Number of partitions must be greater than 0!";
                if (this.firstSmallTable.hasSpill()) {
                    this.spilledMapJoinTables = new MapJoinBytesTableContainer[this.mapJoinTables.length];
                    this.hybridMapJoinLeftover = true;
                    for (pos = 0; pos < this.mapJoinTables.length; pos = (int)((byte)(pos + 1))) {
                        MapJoinTableContainer tableContainer = this.mapJoinTables[pos];
                        if (tableContainer == null || !(tableContainer instanceof HybridHashTableContainer)) continue;
                        HybridHashTableContainer hybridHtContainer = (HybridHashTableContainer)tableContainer;
                        hybridHtContainer.dumpStats();
                        HybridHashTableContainer.HashPartition[] hashPartitions = hybridHtContainer.getHashPartitions();
                        for (int i = 0; i < hashPartitions.length; ++i) {
                            if (hashPartitions[i].isHashMapOnDisk()) continue;
                            hybridHtContainer.setTotalInMemRowCount(hybridHtContainer.getTotalInMemRowCount() - hashPartitions[i].getHashMapFromMemory().getNumValues());
                            hashPartitions[i].getHashMapFromMemory().clear();
                        }
                        assert (hybridHtContainer.getTotalInMemRowCount() == 0);
                    }
                    for (int i = 0; i < numPartitions; ++i) {
                        HybridHashTableContainer.HashPartition[] hashPartitions = this.firstSmallTable.getHashPartitions();
                        if (!hashPartitions[i].isHashMapOnDisk()) continue;
                        try {
                            this.continueProcess(i);
                        }
                        catch (KryoException ke) {
                            LOG.error("Processing the spilled data failed due to Kryo error!");
                            LOG.error("Cleaning up all spilled data!");
                            this.cleanupGraceHashJoin();
                            throw new HiveException(ke);
                        }
                        catch (Exception e) {
                            throw new HiveException(e);
                        }
                        for (int pos2 = 0; pos2 < this.order.length; pos2 = (int)((byte)(pos2 + 1))) {
                            if (pos2 == ((MapJoinDesc)this.conf).getPosBigTable()) continue;
                            this.spilledMapJoinTables[pos2] = null;
                        }
                    }
                }
            }
            if (LOG.isInfoEnabled()) {
                LOG.info("spilled: " + spilled + " abort: " + abort + ". Clearing spilled partitions.");
            }
            this.clearAllTableContainers();
            this.cache.remove(this.cacheKey);
        }
        if (!(this.getExecContext() == null || this.getExecContext().getLocalWork() == null || !this.getExecContext().getLocalWork().getInputFileChangeSensitive() || HiveConf.getVar(this.hconf, HiveConf.ConfVars.HIVE_EXECUTION_ENGINE).equals("spark") && SparkUtilities.isDedicatedCluster(this.hconf))) {
            if (LOG.isInfoEnabled()) {
                LOG.info("MR: Clearing all map join table containers.");
            }
            this.clearAllTableContainers();
        }
        this.loader = null;
        super.closeOp(abort);
    }

    private void clearAllTableContainers() {
        if (this.mapJoinTables != null) {
            for (MapJoinTableContainer tableContainer : this.mapJoinTables) {
                if (tableContainer == null) continue;
                tableContainer.clear();
            }
        }
    }

    private void continueProcess(int partitionId) throws HiveException, IOException, SerDeException, ClassNotFoundException {
        for (byte pos = 0; pos < this.mapJoinTables.length; pos = (byte)((byte)(pos + 1))) {
            if (pos == ((MapJoinDesc)this.conf).getPosBigTable()) continue;
            LOG.info("Going to reload hash partition " + partitionId);
            this.reloadHashTable(pos, partitionId);
        }
        this.reProcessBigTable(partitionId);
    }

    protected void reloadHashTable(byte pos, int partitionId) throws IOException, HiveException, SerDeException, ClassNotFoundException {
        HybridHashTableContainer container = (HybridHashTableContainer)this.mapJoinTables[pos];
        HybridHashTableContainer.HashPartition partition = container.getHashPartitions()[partitionId];
        LOG.info("Going to restore sidefile...");
        KeyValueContainer kvContainer = partition.getSidefileKVContainer();
        int rowCount = kvContainer.size();
        LOG.info("Hybrid Grace Hash Join: Number of rows restored from KeyValueContainer: " + kvContainer.size());
        if (rowCount <= 0) {
            rowCount = 0x100000;
        }
        LOG.info("Going to restore hashmap...");
        BytesBytesMultiHashMap restoredHashMap = partition.getHashMapFromDisk(rowCount);
        LOG.info("Hybrid Grace Hash Join: Deserializing spilled hash partition...");
        LOG.info("Hybrid Grace Hash Join: Number of rows in hashmap: " + (rowCount += restoredHashMap.getNumValues()));
        if ((long)rowCount * container.getTableRowSize() >= container.getMemoryThreshold() / 2L) {
            LOG.warn("Hybrid Grace Hash Join: Hash table cannot be reloaded since it will be greater than memory limit. Recursive spilling is currently not supported");
        }
        MapJoinBytesTableContainer.KeyValueHelper writeHelper = container.getWriteHelper();
        while (kvContainer.hasNext()) {
            ObjectPair<HiveKey, BytesWritable> pair = kvContainer.next();
            Writable key = (Writable)pair.getFirst();
            Writable val = (Writable)pair.getSecond();
            writeHelper.setKeyValue(key, val);
            restoredHashMap.put(writeHelper, -1);
        }
        container.setTotalInMemRowCount(container.getTotalInMemRowCount() + restoredHashMap.getNumValues());
        kvContainer.clear();
        this.spilledMapJoinTables[pos] = new MapJoinBytesTableContainer(restoredHashMap);
        this.spilledMapJoinTables[pos].setInternalValueOi(container.getInternalValueOi());
        this.spilledMapJoinTables[pos].setSortableSortOrders(container.getSortableSortOrders());
        this.spilledMapJoinTables[pos].setNullMarkers(container.getNullMarkers());
        this.spilledMapJoinTables[pos].setNotNullMarkers(container.getNotNullMarkers());
    }

    protected void reProcessBigTable(int partitionId) throws HiveException {
        HybridHashTableContainer.HashPartition partition = this.firstSmallTable.getHashPartitions()[partitionId];
        ObjectContainer bigTable = partition.getMatchfileObjContainer();
        LOG.info("Hybrid Grace Hash Join: Going to process spilled big table rows in partition " + partitionId + ". Number of rows: " + bigTable.size());
        while (bigTable.hasNext()) {
            Object row = bigTable.next();
            this.process(row, ((MapJoinDesc)this.conf).getPosBigTable());
        }
        bigTable.clear();
    }

    private void cleanupGraceHashJoin() {
        for (int pos = 0; pos < this.mapJoinTables.length; pos = (int)((byte)(pos + 1))) {
            if (pos == ((MapJoinDesc)this.conf).getPosBigTable()) continue;
            LOG.info("Cleaning up small table data at pos: " + pos);
            HybridHashTableContainer container = (HybridHashTableContainer)this.mapJoinTables[pos];
            container.clear();
        }
    }

    @Override
    public String getName() {
        return MapJoinOperator.getOperatorName();
    }

    public static String getOperatorName() {
        return "MAPJOIN";
    }

    @Override
    public OperatorType getType() {
        return OperatorType.MAPJOIN;
    }

    protected boolean isInputFileChangeSensitive(ExecMapperContext mapContext) {
        return mapContext != null && mapContext.getLocalWork() != null && mapContext.getLocalWork().getInputFileChangeSensitive();
    }

    protected boolean canSkipReload(ExecMapperContext mapContext) {
        return this.hashTblInitedOnce && !this.isInputFileChangeSensitive(mapContext);
    }

    protected boolean canSkipJoinProcessing(ExecMapperContext mapContext) {
        if (!this.canSkipReload(mapContext)) {
            return false;
        }
        JoinCondDesc[] joinConds = ((MapJoinDesc)this.getConf()).getConds();
        if (joinConds.length > 0) {
            for (JoinCondDesc joinCond : joinConds) {
                if (joinCond.getType() == 0) continue;
                return false;
            }
        } else {
            return false;
        }
        boolean skipJoinProcessing = false;
        for (int idx = 0; idx < this.mapJoinTables.length; ++idx) {
            MapJoinTableContainer mapJoinTable;
            if (idx == ((MapJoinDesc)this.getConf()).getPosBigTable() || (mapJoinTable = this.mapJoinTables[idx]).size() != 0) continue;
            LOG.info("Hash table number " + idx + " is empty");
            skipJoinProcessing = true;
            break;
        }
        return skipJoinProcessing;
    }
}

