/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.repl.bootstrap.load.util;

import com.facebook.presto.hive.$internal.org.slf4j.Logger;
import com.facebook.presto.hive.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.exec.TaskRunner;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.load.util.PathUtils;

public class PathInfo {
    private static Logger LOG = LoggerFactory.getLogger(PathUtils.class);
    private final Map<String, Path> fsScratchDirs = new HashMap<String, Path>();
    private final String stagingDir;
    private final HiveConf hiveConf;

    public PathInfo(HiveConf hiveConf) {
        this.hiveConf = hiveConf;
        this.stagingDir = HiveConf.getVar(hiveConf, HiveConf.ConfVars.STAGINGDIR);
    }

    public Map<String, Path> getFsScratchDirs() {
        return this.fsScratchDirs;
    }

    Path computeStagingDir(Path inputPath) {
        URI inputPathUri = inputPath.toUri();
        String inputPathName = inputPathUri.getPath();
        String fileSystemAsString = inputPathUri.getScheme() + ":" + inputPathUri.getAuthority();
        String stagingPathName = !inputPathName.contains(this.stagingDir) ? new Path(inputPathName, this.stagingDir).toString() : inputPathName.substring(0, inputPathName.indexOf(this.stagingDir) + this.stagingDir.length());
        String key = fileSystemAsString + "-" + stagingPathName + "-" + TaskRunner.getTaskRunnerID();
        Path dir = this.fsScratchDirs.get(key);
        try {
            FileSystem fileSystem = inputPath.getFileSystem((Configuration)this.hiveConf);
            if (dir == null) {
                Path path = new Path(stagingPathName + "_" + Context.generateExecutionId() + "-" + TaskRunner.getTaskRunnerID());
                dir = fileSystem.makeQualified(path);
                LOG.debug("Created staging dir = " + dir + " for path = " + inputPath);
                if (!FileUtils.mkdir(fileSystem, dir, this.hiveConf)) {
                    throw new IllegalStateException("Cannot create staging directory  '" + dir.toString() + "'");
                }
                fileSystem.deleteOnExit(dir);
            }
            this.fsScratchDirs.put(key, dir);
            return dir;
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot create staging directory '" + dir.toString() + "': " + e.getMessage(), e);
        }
    }
}

