/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.ptf;

import com.facebook.presto.hive.$internal.com.google.common.base.Preconditions;
import com.facebook.presto.hive.$internal.org.apache.commons.logging.Log;
import com.facebook.presto.hive.$internal.org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.ptf.VectorPTFEvaluatorBase;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ptf.WindowFrameDef;

public class VectorPTFEvaluatorDoubleLastValue
extends VectorPTFEvaluatorBase {
    private static final long serialVersionUID = 1L;
    private static final String CLASS_NAME = VectorPTFEvaluatorDoubleLastValue.class.getName();
    private static final Log LOG = LogFactory.getLog(CLASS_NAME);
    protected boolean isGroupResultNull;
    protected double lastValue;

    public VectorPTFEvaluatorDoubleLastValue(WindowFrameDef windowFrameDef, VectorExpression inputVecExpr, int outputColumnNum) {
        super(windowFrameDef, inputVecExpr, outputColumnNum);
        this.resetEvaluator();
    }

    @Override
    public void evaluateGroupBatch(VectorizedRowBatch batch, boolean isLastGroupBatch) throws HiveException {
        this.evaluateInputExpr(batch);
        Preconditions.checkState(!batch.selectedInUse);
        if (!isLastGroupBatch) {
            return;
        }
        int size = batch.size;
        if (size == 0) {
            return;
        }
        DoubleColumnVector doubleColVector = (DoubleColumnVector)batch.cols[this.inputColumnNum];
        if (doubleColVector.isRepeating) {
            if (doubleColVector.noNulls || !doubleColVector.isNull[0]) {
                this.lastValue = doubleColVector.vector[0];
                this.isGroupResultNull = false;
            } else {
                this.isGroupResultNull = true;
            }
        } else if (doubleColVector.noNulls) {
            this.lastValue = doubleColVector.vector[size - 1];
            this.isGroupResultNull = false;
        } else {
            int lastBatchIndex = size - 1;
            if (!doubleColVector.isNull[lastBatchIndex]) {
                this.lastValue = doubleColVector.vector[lastBatchIndex];
                this.isGroupResultNull = false;
            } else {
                this.isGroupResultNull = true;
            }
        }
    }

    @Override
    public boolean isGroupResultNull() {
        return this.isGroupResultNull;
    }

    @Override
    public ColumnVector.Type getResultColumnVectorType() {
        return ColumnVector.Type.DOUBLE;
    }

    @Override
    public double getDoubleGroupResult() {
        return this.lastValue;
    }

    @Override
    public void resetEvaluator() {
        this.isGroupResultNull = true;
        this.lastValue = 0.0;
    }
}

