/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.hooks;

import com.facebook.presto.hive.$internal.org.slf4j.Logger;
import com.facebook.presto.hive.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hive.ql.hooks.ExecuteWithHookContext;
import org.apache.hadoop.hive.ql.hooks.HookContext;
import org.apache.hadoop.hive.ql.hooks.PrivateHookContext;
import org.apache.hadoop.hive.ql.optimizer.signature.OpTreeSignature;
import org.apache.hadoop.hive.ql.optimizer.signature.RuntimeStatsPersister;
import org.apache.hadoop.hive.ql.plan.mapper.PlanMapper;

public class RuntimeStatsPersistenceCheckerHook
implements ExecuteWithHookContext {
    private static final Logger LOG = LoggerFactory.getLogger(RuntimeStatsPersistenceCheckerHook.class);

    @Override
    public void run(HookContext hookContext) throws Exception {
        OpTreeSignature sig2;
        PlanMapper pm = ((PrivateHookContext)hookContext).getContext().getPlanMapper();
        List<OpTreeSignature> sigs = pm.getAll(OpTreeSignature.class);
        for (OpTreeSignature sig : sigs) {
            try {
                sig2 = this.persistenceLoop(sig, OpTreeSignature.class);
                sig.getSig().proveEquals(sig2.getSig());
            }
            catch (Exception e) {
                throw new RuntimeException("while checking the signature of: " + sig.getSig(), e);
            }
        }
        for (OpTreeSignature sig : sigs) {
            try {
                sig2 = this.persistenceLoop(sig, OpTreeSignature.class);
                if (sig.equals(sig2)) continue;
                throw new RuntimeException("signature mismatch");
            }
            catch (Exception e) {
                throw new RuntimeException("while checking the signature of: " + sig.getSig(), e);
            }
        }
        LOG.info("signature checked: " + sigs.size());
    }

    private <T> T persistenceLoop(T sig, Class<T> clazz) throws IOException {
        RuntimeStatsPersister sp = RuntimeStatsPersister.INSTANCE;
        String stored = sp.encode(sig);
        return sp.decode(stored, clazz);
    }
}

