/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.translator;

import com.facebook.presto.hive.$internal.com.google.common.collect.ImmutableSet;
import com.facebook.presto.hive.$internal.org.slf4j.Logger;
import com.facebook.presto.hive.$internal.org.slf4j.LoggerFactory;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexFieldAccess;
import org.apache.calcite.rex.RexFieldCollation;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexOver;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.rex.RexWindow;
import org.apache.calcite.rex.RexWindowBound;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.util.DateString;
import org.apache.calcite.util.TimeString;
import org.apache.calcite.util.TimestampString;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.common.type.HiveIntervalDayTime;
import org.apache.hadoop.hive.common.type.HiveIntervalYearMonth;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.optimizer.ConstantPropagateProcFactory;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.ASTConverter;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.SqlFunctionConverter;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.TypeConverter;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.PTFInvocationSpec;
import org.apache.hadoop.hive.ql.parse.WindowingSpec;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeFieldDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;

public class ExprNodeConverter
extends RexVisitorImpl<ExprNodeDesc> {
    private final boolean foldExpr;
    private final String tabAlias;
    private final RelDataType inputRowType;
    private final ImmutableSet<Integer> inputVCols;
    private final List<WindowingSpec.WindowFunctionSpec> windowFunctionSpecs = new ArrayList<WindowingSpec.WindowFunctionSpec>();
    private final RelDataTypeFactory dTFactory;
    protected final Logger LOG = LoggerFactory.getLogger(((Object)((Object)this)).getClass().getName());
    private static long uniqueCounter = 0L;

    public ExprNodeConverter(String tabAlias, RelDataType inputRowType, Set<Integer> vCols, RelDataTypeFactory dTFactory) {
        this(tabAlias, null, inputRowType, null, vCols, dTFactory, false);
    }

    public ExprNodeConverter(String tabAlias, RelDataType inputRowType, Set<Integer> vCols, RelDataTypeFactory dTFactory, boolean foldExpr) {
        this(tabAlias, null, inputRowType, null, vCols, dTFactory, foldExpr);
    }

    public ExprNodeConverter(String tabAlias, String columnAlias, RelDataType inputRowType, RelDataType outputRowType, Set<Integer> inputVCols, RelDataTypeFactory dTFactory) {
        this(tabAlias, columnAlias, inputRowType, outputRowType, inputVCols, dTFactory, false);
    }

    public ExprNodeConverter(String tabAlias, String columnAlias, RelDataType inputRowType, RelDataType outputRowType, Set<Integer> inputVCols, RelDataTypeFactory dTFactory, boolean foldExpr) {
        super(true);
        this.tabAlias = tabAlias;
        this.inputRowType = inputRowType;
        this.inputVCols = ImmutableSet.copyOf(inputVCols);
        this.dTFactory = dTFactory;
        this.foldExpr = foldExpr;
    }

    public List<WindowingSpec.WindowFunctionSpec> getWindowFunctionSpec() {
        return this.windowFunctionSpecs;
    }

    public ExprNodeDesc visitInputRef(RexInputRef inputRef) {
        RelDataTypeField f = (RelDataTypeField)this.inputRowType.getFieldList().get(inputRef.getIndex());
        return new ExprNodeColumnDesc(TypeConverter.convert(f.getType()), f.getName(), this.tabAlias, this.inputVCols.contains(inputRef.getIndex()));
    }

    public ExprNodeDesc visitFieldAccess(RexFieldAccess fieldAccess) {
        boolean isList;
        ExprNodeDesc parent = (ExprNodeDesc)fieldAccess.getReferenceExpr().accept((RexVisitor)this);
        String child = fieldAccess.getField().getName();
        TypeInfo parentType = parent.getTypeInfo();
        boolean bl = isList = parentType.getCategory() == ObjectInspector.Category.LIST;
        if (isList) {
            parentType = ((ListTypeInfo)parentType).getListElementTypeInfo();
        }
        TypeInfo t = ((StructTypeInfo)parentType).getStructFieldTypeInfo(child);
        return new ExprNodeFieldDesc(t, parent, child, isList);
    }

    public ExprNodeDesc visitCall(RexCall call) {
        ExprNodeDesc constantExpr;
        ExprNodeDesc gfDesc = null;
        if (!this.deep) {
            return null;
        }
        LinkedList<ExprNodeDesc> args = new LinkedList<ExprNodeDesc>();
        if (call.getKind() == SqlKind.EXTRACT) {
            args.add((ExprNodeDesc)((RexNode)call.operands.get(1)).accept((RexVisitor)this));
        } else if (call.getKind() == SqlKind.FLOOR && call.operands.size() == 2) {
            args.add((ExprNodeDesc)((RexNode)call.operands.get(0)).accept((RexVisitor)this));
        } else {
            for (RexNode operand : call.operands) {
                args.add((ExprNodeDesc)operand.accept((RexVisitor)this));
            }
        }
        if (call.isA(SqlKind.CAST) && call.operands.size() == 1 && SqlTypeUtil.equalSansNullability((RelDataTypeFactory)this.dTFactory, (RelDataType)call.getType(), (RelDataType)((RexNode)call.operands.get(0)).getType())) {
            return (ExprNodeDesc)args.get(0);
        }
        GenericUDF hiveUdf = SqlFunctionConverter.getHiveUDF(call.getOperator(), call.getType(), args.size());
        if (hiveUdf == null) {
            throw new RuntimeException("Cannot find UDF for " + call.getType() + " " + call.getOperator() + "[" + call.getOperator().getKind() + "]/" + args.size());
        }
        try {
            gfDesc = ExprNodeGenericFuncDesc.newInstance(hiveUdf, args);
        }
        catch (UDFArgumentException e) {
            this.LOG.error("Failed to instantiate udf: ", e);
            throw new RuntimeException(e);
        }
        if (this.foldExpr && RexUtil.isConstant((RexNode)call) && (constantExpr = ConstantPropagateProcFactory.foldExpr(gfDesc)) != null) {
            gfDesc = constantExpr;
        }
        return gfDesc;
    }

    public ExprNodeDesc visitLiteral(RexLiteral literal) {
        RelDataType lType = literal.getType();
        if (RexLiteral.value((RexNode)literal) == null) {
            switch (literal.getType().getSqlTypeName()) {
                case BOOLEAN: {
                    return new ExprNodeConstantDesc(TypeInfoFactory.booleanTypeInfo, null);
                }
                case TINYINT: {
                    return new ExprNodeConstantDesc(TypeInfoFactory.byteTypeInfo, null);
                }
                case SMALLINT: {
                    return new ExprNodeConstantDesc(TypeInfoFactory.shortTypeInfo, null);
                }
                case INTEGER: {
                    return new ExprNodeConstantDesc(TypeInfoFactory.intTypeInfo, null);
                }
                case BIGINT: {
                    return new ExprNodeConstantDesc(TypeInfoFactory.longTypeInfo, null);
                }
                case FLOAT: 
                case REAL: {
                    return new ExprNodeConstantDesc(TypeInfoFactory.floatTypeInfo, null);
                }
                case DOUBLE: {
                    return new ExprNodeConstantDesc(TypeInfoFactory.doubleTypeInfo, null);
                }
                case DATE: {
                    return new ExprNodeConstantDesc(TypeInfoFactory.dateTypeInfo, null);
                }
                case TIME: 
                case TIMESTAMP: {
                    return new ExprNodeConstantDesc(TypeInfoFactory.timestampTypeInfo, null);
                }
                case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                    HiveConf conf;
                    try {
                        conf = Hive.get().getConf();
                    }
                    catch (HiveException e) {
                        throw new RuntimeException(e);
                    }
                    return new ExprNodeConstantDesc(TypeInfoFactory.getTimestampTZTypeInfo(conf.getLocalTimeZone()), null);
                }
                case BINARY: {
                    return new ExprNodeConstantDesc(TypeInfoFactory.binaryTypeInfo, null);
                }
                case DECIMAL: {
                    return new ExprNodeConstantDesc(TypeInfoFactory.getDecimalTypeInfo(lType.getPrecision(), lType.getScale()), null);
                }
                case VARCHAR: 
                case CHAR: {
                    return new ExprNodeConstantDesc(TypeInfoFactory.stringTypeInfo, null);
                }
                case INTERVAL_YEAR: 
                case INTERVAL_MONTH: 
                case INTERVAL_YEAR_MONTH: {
                    return new ExprNodeConstantDesc(TypeInfoFactory.intervalYearMonthTypeInfo, null);
                }
                case INTERVAL_DAY: 
                case INTERVAL_DAY_HOUR: 
                case INTERVAL_DAY_MINUTE: 
                case INTERVAL_DAY_SECOND: 
                case INTERVAL_HOUR: 
                case INTERVAL_HOUR_MINUTE: 
                case INTERVAL_HOUR_SECOND: 
                case INTERVAL_MINUTE: 
                case INTERVAL_MINUTE_SECOND: 
                case INTERVAL_SECOND: {
                    return new ExprNodeConstantDesc(TypeInfoFactory.intervalDayTimeTypeInfo, null);
                }
            }
            return new ExprNodeConstantDesc(TypeInfoFactory.voidTypeInfo, null);
        }
        switch (literal.getType().getSqlTypeName()) {
            case BOOLEAN: {
                return new ExprNodeConstantDesc(TypeInfoFactory.booleanTypeInfo, RexLiteral.booleanValue((RexNode)literal));
            }
            case TINYINT: {
                return new ExprNodeConstantDesc(TypeInfoFactory.byteTypeInfo, ((Number)literal.getValue3()).byteValue());
            }
            case SMALLINT: {
                return new ExprNodeConstantDesc(TypeInfoFactory.shortTypeInfo, ((Number)literal.getValue3()).shortValue());
            }
            case INTEGER: {
                return new ExprNodeConstantDesc(TypeInfoFactory.intTypeInfo, ((Number)literal.getValue3()).intValue());
            }
            case BIGINT: {
                return new ExprNodeConstantDesc(TypeInfoFactory.longTypeInfo, ((Number)literal.getValue3()).longValue());
            }
            case FLOAT: 
            case REAL: {
                return new ExprNodeConstantDesc(TypeInfoFactory.floatTypeInfo, Float.valueOf(((Number)literal.getValue3()).floatValue()));
            }
            case DOUBLE: {
                return new ExprNodeConstantDesc(TypeInfoFactory.doubleTypeInfo, ((Number)literal.getValue3()).doubleValue());
            }
            case DATE: {
                return new ExprNodeConstantDesc(TypeInfoFactory.dateTypeInfo, Date.valueOf(((DateString)literal.getValueAs(DateString.class)).toString()));
            }
            case TIME: {
                return new ExprNodeConstantDesc(TypeInfoFactory.timestampTypeInfo, Timestamp.valueOf(((TimeString)literal.getValueAs(TimeString.class)).toString()));
            }
            case TIMESTAMP: {
                return new ExprNodeConstantDesc(TypeInfoFactory.timestampTypeInfo, Timestamp.valueOf(((TimestampString)literal.getValueAs(TimestampString.class)).toString()));
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                HiveConf conf;
                try {
                    conf = Hive.get().getConf();
                }
                catch (HiveException e) {
                    throw new RuntimeException(e);
                }
                return new ExprNodeConstantDesc(TypeInfoFactory.getTimestampTZTypeInfo(conf.getLocalTimeZone()), ((TimestampString)literal.getValueAs(TimestampString.class)).toString() + " UTC");
            }
            case BINARY: {
                return new ExprNodeConstantDesc(TypeInfoFactory.binaryTypeInfo, literal.getValue3());
            }
            case DECIMAL: {
                return new ExprNodeConstantDesc(TypeInfoFactory.getDecimalTypeInfo(lType.getPrecision(), lType.getScale()), HiveDecimal.create((BigDecimal)literal.getValue3()));
            }
            case VARCHAR: 
            case CHAR: {
                return new ExprNodeConstantDesc(TypeInfoFactory.stringTypeInfo, literal.getValue3());
            }
            case INTERVAL_YEAR: 
            case INTERVAL_MONTH: 
            case INTERVAL_YEAR_MONTH: {
                BigDecimal monthsBd = (BigDecimal)literal.getValue();
                return new ExprNodeConstantDesc(TypeInfoFactory.intervalYearMonthTypeInfo, new HiveIntervalYearMonth(monthsBd.intValue()));
            }
            case INTERVAL_DAY: 
            case INTERVAL_DAY_HOUR: 
            case INTERVAL_DAY_MINUTE: 
            case INTERVAL_DAY_SECOND: 
            case INTERVAL_HOUR: 
            case INTERVAL_HOUR_MINUTE: 
            case INTERVAL_HOUR_SECOND: 
            case INTERVAL_MINUTE: 
            case INTERVAL_MINUTE_SECOND: 
            case INTERVAL_SECOND: {
                BigDecimal millisBd = (BigDecimal)literal.getValue();
                BigDecimal secsBd = millisBd.divide(BigDecimal.valueOf(1000L));
                return new ExprNodeConstantDesc(TypeInfoFactory.intervalDayTimeTypeInfo, new HiveIntervalDayTime(secsBd));
            }
        }
        return new ExprNodeConstantDesc(TypeInfoFactory.voidTypeInfo, literal.getValue3());
    }

    public ExprNodeDesc visitOver(RexOver over) {
        if (!this.deep) {
            return null;
        }
        RexWindow window = over.getWindow();
        WindowingSpec.WindowSpec windowSpec = new WindowingSpec.WindowSpec();
        PTFInvocationSpec.PartitioningSpec partitioningSpec = this.getPSpec(window);
        windowSpec.setPartitioning(partitioningSpec);
        WindowingSpec.WindowFrameSpec windowFrameSpec = this.getWindowRange(window);
        windowSpec.setWindowFrame(windowFrameSpec);
        WindowingSpec.WindowFunctionSpec wfs = new WindowingSpec.WindowFunctionSpec();
        wfs.setWindowSpec(windowSpec);
        ASTConverter.Schema schema = new ASTConverter.Schema(this.tabAlias, this.inputRowType.getFieldList());
        ASTNode wUDAFAst = new ASTConverter.RexVisitor(schema).visitOver(over);
        wfs.setExpression(wUDAFAst);
        ASTNode nameNode = (ASTNode)wUDAFAst.getChild(0);
        wfs.setName(nameNode.getText());
        for (int i = 1; i < wUDAFAst.getChildCount() - 1; ++i) {
            ASTNode child = (ASTNode)wUDAFAst.getChild(i);
            wfs.addArg(child);
        }
        if (wUDAFAst.getText().equals("TOK_FUNCTIONSTAR")) {
            wfs.setStar(true);
        }
        String columnAlias = this.getWindowColumnAlias();
        wfs.setAlias(columnAlias);
        this.windowFunctionSpecs.add(wfs);
        return new ExprNodeColumnDesc(TypeConverter.convert(over.getType()), columnAlias, this.tabAlias, false);
    }

    private PTFInvocationSpec.PartitioningSpec getPSpec(RexWindow window) {
        PTFInvocationSpec.PartitionExpression exprSpec;
        PTFInvocationSpec.PartitioningSpec partitioning = new PTFInvocationSpec.PartitioningSpec();
        ASTConverter.Schema schema = new ASTConverter.Schema(this.tabAlias, this.inputRowType.getFieldList());
        if (window.partitionKeys != null && !window.partitionKeys.isEmpty()) {
            PTFInvocationSpec.PartitionSpec pSpec = new PTFInvocationSpec.PartitionSpec();
            for (RexNode pk : window.partitionKeys) {
                exprSpec = new PTFInvocationSpec.PartitionExpression();
                ASTNode astNode = (ASTNode)pk.accept((RexVisitor)new ASTConverter.RexVisitor(schema));
                exprSpec.setExpression(astNode);
                pSpec.addExpression(exprSpec);
            }
            partitioning.setPartSpec(pSpec);
        }
        if (window.orderKeys != null && !window.orderKeys.isEmpty()) {
            PTFInvocationSpec.OrderSpec oSpec = new PTFInvocationSpec.OrderSpec();
            for (RexFieldCollation ok : window.orderKeys) {
                PTFInvocationSpec.Order order;
                exprSpec = new PTFInvocationSpec.OrderExpression();
                PTFInvocationSpec.Order order2 = order = ok.getDirection() == RelFieldCollation.Direction.ASCENDING ? PTFInvocationSpec.Order.ASC : PTFInvocationSpec.Order.DESC;
                PTFInvocationSpec.NullOrder nullOrder = ((ImmutableSet)ok.right).contains(SqlKind.NULLS_FIRST) ? PTFInvocationSpec.NullOrder.NULLS_FIRST : (((ImmutableSet)ok.right).contains(SqlKind.NULLS_LAST) ? PTFInvocationSpec.NullOrder.NULLS_LAST : (ok.getDirection() == RelFieldCollation.Direction.ASCENDING ? PTFInvocationSpec.NullOrder.NULLS_FIRST : PTFInvocationSpec.NullOrder.NULLS_LAST));
                ((PTFInvocationSpec.OrderExpression)exprSpec).setOrder(order);
                ((PTFInvocationSpec.OrderExpression)exprSpec).setNullOrder(nullOrder);
                ASTNode astNode = (ASTNode)((RexNode)ok.left).accept((RexVisitor)new ASTConverter.RexVisitor(schema));
                exprSpec.setExpression(astNode);
                oSpec.addExpression((PTFInvocationSpec.OrderExpression)exprSpec);
            }
            partitioning.setOrderSpec(oSpec);
        }
        return partitioning;
    }

    private WindowingSpec.WindowFrameSpec getWindowRange(RexWindow window) {
        WindowingSpec.BoundarySpec start = null;
        RexWindowBound ub = window.getUpperBound();
        if (ub != null) {
            start = this.getWindowBound(ub);
        }
        WindowingSpec.BoundarySpec end = null;
        RexWindowBound lb = window.getLowerBound();
        if (lb != null) {
            end = this.getWindowBound(lb);
        }
        return new WindowingSpec.WindowFrameSpec(window.isRows() ? WindowingSpec.WindowType.ROWS : WindowingSpec.WindowType.RANGE, start, end);
    }

    private WindowingSpec.BoundarySpec getWindowBound(RexWindowBound wb) {
        WindowingSpec.BoundarySpec boundarySpec;
        if (wb.isCurrentRow()) {
            boundarySpec = new WindowingSpec.BoundarySpec(WindowingSpec.Direction.CURRENT);
        } else {
            WindowingSpec.Direction direction = wb.isPreceding() ? WindowingSpec.Direction.PRECEDING : WindowingSpec.Direction.FOLLOWING;
            int amt = wb.isUnbounded() ? Integer.MAX_VALUE : RexLiteral.intValue((RexNode)wb.getOffset());
            boundarySpec = new WindowingSpec.BoundarySpec(direction, amt);
        }
        return boundarySpec;
    }

    private String getWindowColumnAlias() {
        return "$win$_col_" + uniqueCounter++;
    }
}

