/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.physical;

import com.facebook.presto.hive.$internal.org.slf4j.Logger;
import com.facebook.presto.hive.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Stack;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.StringInternUtils;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat;
import org.apache.hadoop.hive.ql.io.NullScanFileSystem;
import org.apache.hadoop.hive.ql.io.OneNullRowInputFormat;
import org.apache.hadoop.hive.ql.io.ZeroRowsInputFormat;
import org.apache.hadoop.hive.ql.lib.DefaultRuleDispatcher;
import org.apache.hadoop.hive.ql.lib.Dispatcher;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.PreOrderOnceWalker;
import org.apache.hadoop.hive.ql.lib.Rule;
import org.apache.hadoop.hive.ql.optimizer.physical.MetadataOnlyOptimizer;
import org.apache.hadoop.hive.ql.optimizer.physical.PhysicalContext;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.apache.hadoop.hive.serde2.NullStructSerDe;

public class NullScanTaskDispatcher
implements Dispatcher {
    static final Logger LOG = LoggerFactory.getLogger(NullScanTaskDispatcher.class.getName());
    private final PhysicalContext physicalContext;
    private final Map<Rule, NodeProcessor> rules;

    public NullScanTaskDispatcher(PhysicalContext context, Map<Rule, NodeProcessor> rules) {
        this.physicalContext = context;
        this.rules = rules;
    }

    private String getAliasForTableScanOperator(MapWork work, TableScanOperator tso) {
        for (Map.Entry<String, Operator<? extends OperatorDesc>> entry : work.getAliasToWork().entrySet()) {
            if (entry.getValue() != tso) continue;
            return entry.getKey();
        }
        return null;
    }

    private PartitionDesc changePartitionToMetadataOnly(PartitionDesc desc, Path path) {
        if (desc == null) {
            return null;
        }
        boolean isEmpty = false;
        try {
            isEmpty = Utilities.isEmptyPath(this.physicalContext.getConf(), path);
        }
        catch (IOException e) {
            LOG.error("Cannot determine if the table is empty", e);
        }
        desc.setInputFileFormatClass(isEmpty ? ZeroRowsInputFormat.class : OneNullRowInputFormat.class);
        desc.setOutputFileFormatClass(HiveIgnoreKeyTextOutputFormat.class);
        desc.getProperties().setProperty("serialization.lib", NullStructSerDe.class.getName());
        return desc;
    }

    private void processAlias(MapWork work, Path path, ArrayList<String> aliasesAffected, ArrayList<String> aliases) {
        ArrayList<String> allowed = new ArrayList<String>();
        for (String alias : aliasesAffected) {
            if (!aliases.contains(alias)) continue;
            allowed.add(alias);
        }
        if (allowed.size() > 0) {
            PartitionDesc partDesc = work.getPathToPartitionInfo().get(path).clone();
            PartitionDesc newPartition = this.changePartitionToMetadataOnly(partDesc, path);
            Path fakePath = new Path(NullScanFileSystem.getBase() + newPartition.getTableName() + "/part" + this.encode(newPartition.getPartSpec()));
            StringInternUtils.internUriStringsInPath(fakePath);
            work.addPathToPartitionInfo(fakePath, newPartition);
            work.addPathToAlias(fakePath, new ArrayList<String>(allowed));
            aliasesAffected.removeAll(allowed);
            if (aliasesAffected.isEmpty()) {
                work.removePathToAlias(path);
                work.removePathToPartitionInfo(path);
            }
        }
    }

    private void processAlias(MapWork work, HashSet<TableScanOperator> tableScans) {
        ArrayList<String> aliases = new ArrayList<String>();
        for (TableScanOperator tso : tableScans) {
            if (((TableScanDesc)tso.getConf()).getTableMetadata().getStorageHandler() != null) continue;
            String string = this.getAliasForTableScanOperator(work, tso);
            aliases.add(string);
            ((TableScanDesc)tso.getConf()).setIsMetadataOnly(true);
        }
        LinkedHashMap<Path, ArrayList<String>> candidates = new LinkedHashMap<Path, ArrayList<String>>();
        for (Path path : work.getPaths()) {
            ArrayList<String> aliasesAffected = work.getPathToAliases().get(path);
            if (aliasesAffected == null || aliasesAffected.size() <= 0) continue;
            candidates.put(path, aliasesAffected);
        }
        for (Map.Entry entry : candidates.entrySet()) {
            this.processAlias(work, (Path)entry.getKey(), (ArrayList)entry.getValue(), aliases);
        }
    }

    private String encode(Map<String, String> partSpec) {
        return partSpec.toString().replaceAll("[{}:/#\\?, ]+", "_");
    }

    @Override
    public Object dispatch(Node nd, Stack<Node> stack, Object ... nodeOutputs) throws SemanticException {
        Task task = (Task)nd;
        ParseContext parseContext = this.physicalContext.getParseContext();
        MetadataOnlyOptimizer.WalkerCtx walkerCtx = new MetadataOnlyOptimizer.WalkerCtx();
        ArrayList<MapWork> mapWorks = new ArrayList<MapWork>(task.getMapWork());
        Collections.sort(mapWorks, new Comparator<MapWork>(){

            @Override
            public int compare(MapWork o1, MapWork o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        for (MapWork mapWork : mapWorks) {
            LOG.debug("Looking at: " + mapWork.getName());
            Collection<Operator<? extends OperatorDesc>> topOperators = mapWork.getAliasToWork().values();
            if (topOperators.size() == 0) {
                LOG.debug("No top operators");
                return null;
            }
            LOG.debug("Looking for table scans where optimization is applicable");
            DefaultRuleDispatcher disp = new DefaultRuleDispatcher(null, this.rules, walkerCtx);
            PreOrderOnceWalker ogw = new PreOrderOnceWalker(disp);
            ArrayList<Node> topNodes = new ArrayList<Node>();
            for (Operator<? extends OperatorDesc> workOperator : topOperators) {
                if (!parseContext.getTopOps().values().contains(workOperator)) continue;
                topNodes.add(workOperator);
            }
            Operator<OperatorDesc> reducer = task.getReducer(mapWork);
            if (reducer != null) {
                topNodes.add(reducer);
            }
            ogw.startWalking(topNodes, null);
            LOG.debug(String.format("Found %d null table scans", walkerCtx.getMetadataOnlyTableScans().size()));
            if (walkerCtx.getMetadataOnlyTableScans().size() <= 0) continue;
            this.processAlias(mapWork, walkerCtx.getMetadataOnlyTableScans());
        }
        return null;
    }
}

