/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.RowSchema;
import org.apache.hadoop.hive.ql.plan.SkewedColumnPositionPair;

public class ListBucketingCtx
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<String> skewedColNames;
    private List<List<String>> skewedColValues;
    private Map<List<String>, String> lbLocationMap;
    private List<SkewedColumnPositionPair> rowSkewedIndex = new ArrayList<SkewedColumnPositionPair>();
    private boolean isStoredAsSubDirectories;
    private String defaultKey;
    private String defaultDirName;
    private List<String> skewedValuesDirNames = new ArrayList<String>();

    public List<String> getSkewedColNames() {
        return this.skewedColNames;
    }

    public void setSkewedColNames(List<String> skewedColNames) {
        this.skewedColNames = skewedColNames;
    }

    public List<List<String>> getSkewedColValues() {
        return this.skewedColValues;
    }

    public void setSkewedColValues(List<List<String>> skewedColValues) {
        this.skewedColValues = skewedColValues;
    }

    public Map<List<String>, String> getLbLocationMap() {
        return this.lbLocationMap;
    }

    public void setLbLocationMap(Map<List<String>, String> lbLocationMap) {
        this.lbLocationMap = lbLocationMap;
    }

    public void processRowSkewedIndex(RowSchema rowSch) {
        if (this.skewedColNames != null && this.skewedColNames.size() > 0 && rowSch != null && rowSch.getSignature() != null && rowSch.getSignature().size() > 0) {
            ArrayList<ColumnInfo> cols = rowSch.getSignature();
            int hitNo = 0;
            for (int i = 0; i < cols.size(); ++i) {
                int index = this.skewedColNames.indexOf(((ColumnInfo)cols.get(i)).getInternalName());
                if (index <= -1) continue;
                ++hitNo;
                SkewedColumnPositionPair pair = new SkewedColumnPositionPair(i, index);
                this.rowSkewedIndex.add(pair);
            }
            assert (hitNo == this.skewedColNames.size()) : "RowSchema doesn't have all skewed columns.Skewed column: " + this.skewedColNames.toString() + ". Rowschema has columns: " + cols;
        }
    }

    public void calculateSkewedValueSubDirList() {
        if (this.isSkewedStoredAsDir()) {
            for (List<String> value : this.skewedColValues) {
                this.skewedValuesDirNames.add(FileUtils.makeListBucketingDirName(this.skewedColNames, value));
            }
            this.skewedValuesDirNames.add(FileUtils.makeDefaultListBucketingDirName(this.skewedColNames, "HIVE_DEFAULT_LIST_BUCKETING_DIR_NAME"));
        }
    }

    public boolean isStoredAsSubDirectories() {
        return this.isStoredAsSubDirectories;
    }

    public void setStoredAsSubDirectories(boolean isStoredAsSubDirectories) {
        this.isStoredAsSubDirectories = isStoredAsSubDirectories;
    }

    public String getDefaultKey() {
        return this.defaultKey;
    }

    public void setDefaultKey(String defaultKey) {
        this.defaultKey = defaultKey;
    }

    public String getDefaultDirName() {
        return this.defaultDirName;
    }

    public void setDefaultDirName(String defaultDirName) {
        this.defaultDirName = defaultDirName;
    }

    public boolean isSkewedStoredAsDir() {
        return this.getSkewedColNames() != null && this.getSkewedColNames().size() > 0 && this.getSkewedColValues() != null && this.getSkewedColValues().size() > 0 && this.isStoredAsSubDirectories();
    }

    public int calculateListBucketingLevel() {
        int lbLevel = this.isSkewedStoredAsDir() ? this.getSkewedColNames().size() : 0;
        return lbLevel;
    }

    public List<String> getSkewedValuesDirNames() {
        return this.skewedValuesDirNames;
    }

    public void setSkewedValuesDirNames(List<String> skewedValuesDirNames) {
        this.skewedValuesDirNames = skewedValuesDirNames;
    }

    public List<SkewedColumnPositionPair> getRowSkewedIndex() {
        return this.rowSkewedIndex;
    }

    public void setRowSkewedIndex(List<SkewedColumnPositionPair> rowSkewedIndex) {
        this.rowSkewedIndex = rowSkewedIndex;
    }
}

