/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import com.facebook.presto.hive.$internal.org.slf4j.Logger;
import com.facebook.presto.hive.$internal.org.slf4j.LoggerFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.exec.vector.ptf.VectorPTFEvaluatorBase;
import org.apache.hadoop.hive.ql.parse.LeadLagInfo;
import org.apache.hadoop.hive.ql.plan.AbstractOperatorDesc;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hadoop.hive.ql.plan.OperatorExplainVectorization;
import org.apache.hadoop.hive.ql.plan.PlanUtils;
import org.apache.hadoop.hive.ql.plan.VectorPTFDesc;
import org.apache.hadoop.hive.ql.plan.VectorPTFInfo;
import org.apache.hadoop.hive.ql.plan.VectorizationCondition;
import org.apache.hadoop.hive.ql.plan.ptf.PTFInputDef;
import org.apache.hadoop.hive.ql.plan.ptf.PartitionedTableFunctionDef;
import org.apache.hadoop.hive.ql.plan.ptf.WindowTableFunctionDef;
import org.apache.hadoop.hive.ql.udf.ptf.Noop;

@Explain(displayName="PTF Operator", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
public class PTFDesc
extends AbstractOperatorDesc {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(PTFDesc.class.getName());
    PartitionedTableFunctionDef funcDef;
    transient LeadLagInfo llInfo;
    boolean isMapSide = false;
    transient Configuration cfg;

    public PartitionedTableFunctionDef getFuncDef() {
        return this.funcDef;
    }

    public void setFuncDef(PartitionedTableFunctionDef funcDef) {
        this.funcDef = funcDef;
    }

    public PartitionedTableFunctionDef getStartOfChain() {
        return this.funcDef == null ? null : this.funcDef.getStartOfChain();
    }

    @Explain(displayName="Function definitions", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public List<PTFInputDef> getFuncDefExplain() {
        if (this.funcDef == null) {
            return null;
        }
        ArrayList<PTFInputDef> inputs = new ArrayList<PTFInputDef>();
        for (PTFInputDef current = this.funcDef; current != null; current = ((PTFInputDef)current).getInput()) {
            inputs.add(current);
        }
        Collections.reverse(inputs);
        return inputs;
    }

    public LeadLagInfo getLlInfo() {
        return this.llInfo;
    }

    public void setLlInfo(LeadLagInfo llInfo) {
        this.llInfo = llInfo;
    }

    @Explain(displayName="Lead/Lag information")
    public String getLlInfoExplain() {
        if (this.llInfo != null && this.llInfo.getLeadLagExprs() != null) {
            return PlanUtils.getExprListString(this.llInfo.getLeadLagExprs());
        }
        return null;
    }

    public boolean forWindowing() {
        return this.funcDef instanceof WindowTableFunctionDef;
    }

    public boolean forNoop() {
        return this.funcDef.getTFunction() instanceof Noop;
    }

    @Explain(displayName="Map-side function", displayOnlyOnTrue=true)
    public boolean isMapSide() {
        return this.isMapSide;
    }

    public void setMapSide(boolean isMapSide) {
        this.isMapSide = isMapSide;
    }

    public Configuration getCfg() {
        return this.cfg;
    }

    public void setCfg(Configuration cfg) {
        this.cfg = cfg;
    }

    @Explain(vectorization=Explain.Vectorization.OPERATOR, displayName="PTF Vectorization", explainLevels={Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public PTFOperatorExplainVectorization getPTFVectorization() {
        VectorPTFDesc vectorPTFDesc = (VectorPTFDesc)this.getVectorDesc();
        if (vectorPTFDesc == null) {
            return null;
        }
        return new PTFOperatorExplainVectorization(this, vectorPTFDesc);
    }

    public class PTFOperatorExplainVectorization
    extends OperatorExplainVectorization {
        private final PTFDesc PTFDesc;
        private final VectorPTFDesc vectorPTFDesc;
        private final VectorPTFInfo vectorPTFInfo;
        private VectorizationCondition[] nativeConditions;

        public PTFOperatorExplainVectorization(PTFDesc PTFDesc2, VectorPTFDesc vectorPTFDesc) {
            super(vectorPTFDesc, true);
            this.PTFDesc = PTFDesc2;
            this.vectorPTFDesc = vectorPTFDesc;
            this.vectorPTFInfo = vectorPTFDesc.getVectorPTFInfo();
        }

        @Explain(vectorization=Explain.Vectorization.EXPRESSION, displayName="functionNames", explainLevels={Explain.Level.DEFAULT, Explain.Level.EXTENDED})
        public String getFunctionNames() {
            return Arrays.toString(this.vectorPTFDesc.getEvaluatorFunctionNames());
        }

        @Explain(vectorization=Explain.Vectorization.EXPRESSION, displayName="functionInputExpressions", explainLevels={Explain.Level.DEFAULT, Explain.Level.EXTENDED})
        public String getFunctionInputExpressions() {
            return Arrays.toString(this.vectorPTFInfo.getEvaluatorInputExpressions());
        }

        @Explain(vectorization=Explain.Vectorization.EXPRESSION, displayName="partitionExpressions", explainLevels={Explain.Level.DEFAULT, Explain.Level.EXTENDED})
        public String getPartitionExpressions() {
            Object[] partitionExpressions = this.vectorPTFInfo.getPartitionExpressions();
            if (partitionExpressions == null) {
                return null;
            }
            return Arrays.toString(partitionExpressions);
        }

        @Explain(vectorization=Explain.Vectorization.EXPRESSION, displayName="orderExpressions", explainLevels={Explain.Level.DEFAULT, Explain.Level.EXTENDED})
        public String getOrderExpressions() {
            Object[] orderExpressions = this.vectorPTFInfo.getOrderExpressions();
            if (orderExpressions == null) {
                return null;
            }
            return Arrays.toString(orderExpressions);
        }

        @Explain(vectorization=Explain.Vectorization.EXPRESSION, displayName="evaluatorClasses", explainLevels={Explain.Level.DEFAULT, Explain.Level.EXTENDED})
        public String getEvaluatorClasses() {
            VectorPTFEvaluatorBase[] evaluators = VectorPTFDesc.getEvaluators(this.vectorPTFDesc, this.vectorPTFInfo);
            ArrayList<String> result = new ArrayList<String>(evaluators.length);
            for (VectorPTFEvaluatorBase evaluator : evaluators) {
                result.add(evaluator.getClass().getSimpleName());
            }
            return result.toString();
        }

        @Explain(vectorization=Explain.Vectorization.DETAIL, displayName="outputColumns", explainLevels={Explain.Level.DEFAULT, Explain.Level.EXTENDED})
        public String getOutputColumns() {
            return Arrays.toString(this.vectorPTFInfo.getOutputColumnMap());
        }

        @Explain(vectorization=Explain.Vectorization.DETAIL, displayName="outputTypes", explainLevels={Explain.Level.DEFAULT, Explain.Level.EXTENDED})
        public String getOutputTypes() {
            return Arrays.toString(this.vectorPTFDesc.getOutputTypeInfos());
        }

        @Explain(vectorization=Explain.Vectorization.DETAIL, displayName="keyInputColumns", explainLevels={Explain.Level.DEFAULT, Explain.Level.EXTENDED})
        public String getKeyInputColumns() {
            return Arrays.toString(this.vectorPTFInfo.getKeyInputColumnMap());
        }

        @Explain(vectorization=Explain.Vectorization.DETAIL, displayName="nonKeyInputColumns", explainLevels={Explain.Level.DEFAULT, Explain.Level.EXTENDED})
        public String getNonKeyInputColumns() {
            return Arrays.toString(this.vectorPTFInfo.getNonKeyInputColumnMap());
        }

        @Explain(vectorization=Explain.Vectorization.DETAIL, displayName="streamingColumns", explainLevels={Explain.Level.DEFAULT, Explain.Level.EXTENDED})
        public String getStreamingColumns() {
            VectorPTFEvaluatorBase[] evaluators = VectorPTFDesc.getEvaluators(this.vectorPTFDesc, this.vectorPTFInfo);
            ArrayList<Integer> result = new ArrayList<Integer>();
            for (VectorPTFEvaluatorBase evaluator : evaluators) {
                if (!evaluator.streamsResult()) continue;
                result.add(evaluator.getOutputColumnNum());
            }
            return result.toString();
        }
    }
}

