/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.hadoop.hive.common.type.DataTypePhysicalVariation;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.metadata.VirtualColumn;
import org.apache.hadoop.hive.ql.optimizer.signature.Signature;
import org.apache.hadoop.hive.ql.parse.TableSample;
import org.apache.hadoop.hive.ql.plan.AbstractOperatorDesc;
import org.apache.hadoop.hive.ql.plan.BaseWork;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hadoop.hive.ql.plan.ExprNodeDescUtils;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.plan.IStatsGatherDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.OperatorExplainVectorization;
import org.apache.hadoop.hive.ql.plan.PlanUtils;
import org.apache.hadoop.hive.ql.plan.VectorTableScanDesc;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;

@Explain(displayName="TableScan", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
public class TableScanDesc
extends AbstractOperatorDesc
implements IStatsGatherDesc {
    private static final long serialVersionUID = 1L;
    private String alias;
    private List<VirtualColumn> virtualCols;
    private String statsAggKeyPrefix;
    private List<String> partColumns;
    private int rowLimit = -1;
    private boolean gatherStats;
    private boolean statsReliable;
    private String tmpStatsDir;
    private ExprNodeGenericFuncDesc filterExpr;
    private Serializable filterObject;
    private String serializedFilterExpr;
    private String serializedFilterObject;
    private List<Integer> neededColumnIDs;
    private List<String> neededColumns;
    private List<String> neededNestedColumnPaths;
    private transient List<String> referencedColumns;
    public static final String FILTER_EXPR_CONF_STR = "hive.io.filter.expr.serialized";
    public static final String FILTER_TEXT_CONF_STR = "hive.io.filter.text";
    public static final String FILTER_OBJECT_CONF_STR = "hive.io.filter.object";
    private Map<String, Integer> bucketFileNameMapping;
    private String dbName = null;
    private String tableName = null;
    private boolean isMetadataOnly = false;
    private boolean isTranscationalTable;
    private boolean vectorized;
    private AcidUtils.AcidOperationalProperties acidOperationalProperties = null;
    private transient TableSample tableSample;
    private transient Table tableMetadata;
    private BitSet includedBuckets;
    private int numBuckets = -1;

    public TableScanDesc() {
        this(null, null);
    }

    public TableScanDesc(Table tblMetadata) {
        this(null, tblMetadata);
    }

    public TableScanDesc(String alias, Table tblMetadata) {
        this(alias, null, tblMetadata);
    }

    public TableScanDesc(String alias, List<VirtualColumn> vcs, Table tblMetadata) {
        this.alias = alias;
        this.virtualCols = vcs;
        this.tableMetadata = tblMetadata;
        if (tblMetadata != null) {
            this.dbName = tblMetadata.getDbName();
            this.tableName = tblMetadata.getTableName();
        }
        this.isTranscationalTable = AcidUtils.isTransactionalTable(this.tableMetadata);
        if (this.isTranscationalTable) {
            this.acidOperationalProperties = AcidUtils.getAcidOperationalProperties(this.tableMetadata);
        }
    }

    @Override
    public Object clone() {
        ArrayList<VirtualColumn> vcs = new ArrayList<VirtualColumn>(this.getVirtualCols());
        return new TableScanDesc(this.getAlias(), vcs, this.tableMetadata);
    }

    @Explain(displayName="alias")
    @Signature
    public String getAlias() {
        return this.alias;
    }

    @Signature
    public String getPredicateString() {
        if (this.filterExpr == null) {
            return null;
        }
        return PlanUtils.getExprListString(Arrays.asList(this.filterExpr));
    }

    @Explain(displayName="table", jsonOnly=true)
    public String getTableName() {
        return this.tableName;
    }

    @Explain(displayName="database", jsonOnly=true)
    public String getDatabaseName() {
        return this.dbName;
    }

    @Explain(displayName="columns", jsonOnly=true)
    public List<String> getColumnNamesForExplain() {
        return this.neededColumns;
    }

    @Explain(displayName="isTempTable", jsonOnly=true)
    public boolean isTemporary() {
        return this.tableMetadata.isTemporary();
    }

    @Explain(explainLevels={Explain.Level.USER})
    public String getTbl() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.tableMetadata.getCompleteName());
        sb.append("," + this.alias);
        if (AcidUtils.isFullAcidTable(this.tableMetadata)) {
            sb.append(", ACID table");
        } else if (this.isTranscationalTable()) {
            sb.append(", transactional table");
        }
        sb.append(",Tbl:");
        sb.append((Object)this.statistics.getBasicStatsState());
        sb.append(",Col:");
        sb.append((Object)this.statistics.getColumnStatsState());
        return sb.toString();
    }

    public boolean isTranscationalTable() {
        return this.isTranscationalTable;
    }

    public AcidUtils.AcidOperationalProperties getAcidOperationalProperties() {
        return this.acidOperationalProperties;
    }

    @Explain(displayName="Output", explainLevels={Explain.Level.USER})
    public List<String> getOutputColumnNames() {
        return this.neededColumns;
    }

    @Explain(displayName="filterExpr")
    public String getFilterExprString() {
        if (this.filterExpr == null) {
            return null;
        }
        return PlanUtils.getExprListString(Arrays.asList(this.filterExpr));
    }

    public ExprNodeGenericFuncDesc getFilterExpr() {
        return this.filterExpr;
    }

    public void setFilterExpr(ExprNodeGenericFuncDesc filterExpr) {
        this.filterExpr = filterExpr;
    }

    public Serializable getFilterObject() {
        return this.filterObject;
    }

    public void setFilterObject(Serializable filterObject) {
        this.filterObject = filterObject;
    }

    public void setNeededColumnIDs(List<Integer> neededColumnIDs) {
        this.neededColumnIDs = neededColumnIDs;
    }

    public List<Integer> getNeededColumnIDs() {
        return this.neededColumnIDs;
    }

    public List<String> getNeededNestedColumnPaths() {
        return this.neededNestedColumnPaths;
    }

    public void setNeededNestedColumnPaths(List<String> neededNestedColumnPaths) {
        this.neededNestedColumnPaths = neededNestedColumnPaths;
    }

    public void setNeededColumns(List<String> neededColumns) {
        this.neededColumns = neededColumns;
    }

    public List<String> getNeededColumns() {
        return this.neededColumns;
    }

    @Explain(displayName="Pruned Column Paths")
    public List<String> getPrunedColumnPaths() {
        ArrayList<String> result = new ArrayList<String>();
        for (String p : this.neededNestedColumnPaths) {
            if (p.indexOf(46) < 0) continue;
            result.add(p);
        }
        return result;
    }

    public void setReferencedColumns(List<String> referencedColumns) {
        this.referencedColumns = referencedColumns;
    }

    public List<String> getReferencedColumns() {
        return this.referencedColumns;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public void setPartColumns(List<String> partColumns) {
        this.partColumns = partColumns;
    }

    public List<String> getPartColumns() {
        return this.partColumns;
    }

    public void setGatherStats(boolean gatherStats) {
        this.gatherStats = gatherStats;
    }

    @Override
    @Explain(displayName="GatherStats", explainLevels={Explain.Level.EXTENDED})
    @Signature
    public boolean isGatherStats() {
        return this.gatherStats;
    }

    @Override
    public String getTmpStatsDir() {
        return this.tmpStatsDir;
    }

    public void setTmpStatsDir(String tmpStatsDir) {
        this.tmpStatsDir = tmpStatsDir;
    }

    public List<VirtualColumn> getVirtualCols() {
        return this.virtualCols;
    }

    public void setVirtualCols(List<VirtualColumn> virtualCols) {
        this.virtualCols = virtualCols;
    }

    public void addVirtualCols(List<VirtualColumn> virtualCols) {
        this.virtualCols.addAll(virtualCols);
    }

    public boolean hasVirtualCols() {
        return this.virtualCols != null && !this.virtualCols.isEmpty();
    }

    public void setStatsAggPrefix(String k) {
        this.statsAggKeyPrefix = k;
    }

    @Override
    @Explain(displayName="Statistics Aggregation Key Prefix", explainLevels={Explain.Level.EXTENDED})
    public String getStatsAggPrefix() {
        return this.statsAggKeyPrefix;
    }

    public boolean isStatsReliable() {
        return this.statsReliable;
    }

    public void setStatsReliable(boolean statsReliable) {
        this.statsReliable = statsReliable;
    }

    public void setRowLimit(int rowLimit) {
        this.rowLimit = rowLimit;
    }

    @Signature
    public int getRowLimit() {
        return this.rowLimit;
    }

    @Explain(displayName="Row Limit Per Split")
    public Integer getRowLimitExplain() {
        return this.rowLimit >= 0 ? Integer.valueOf(this.rowLimit) : null;
    }

    public Map<String, Integer> getBucketFileNameMapping() {
        return this.bucketFileNameMapping;
    }

    public void setBucketFileNameMapping(Map<String, Integer> bucketFileNameMapping) {
        this.bucketFileNameMapping = bucketFileNameMapping;
    }

    public void setIsMetadataOnly(boolean metadata_only) {
        this.isMetadataOnly = metadata_only;
    }

    public boolean getIsMetadataOnly() {
        return this.isMetadataOnly;
    }

    public String getQualifiedTable() {
        return this.tableMetadata.getFullyQualifiedName();
    }

    public Table getTableMetadata() {
        return this.tableMetadata;
    }

    public void setTableMetadata(Table tableMetadata) {
        this.tableMetadata = tableMetadata;
    }

    public TableSample getTableSample() {
        return this.tableSample;
    }

    public void setTableSample(TableSample tableSample) {
        this.tableSample = tableSample;
    }

    public String getSerializedFilterExpr() {
        return this.serializedFilterExpr;
    }

    public void setSerializedFilterExpr(String serializedFilterExpr) {
        this.serializedFilterExpr = serializedFilterExpr;
    }

    public String getSerializedFilterObject() {
        return this.serializedFilterObject;
    }

    public void setSerializedFilterObject(String serializedFilterObject) {
        this.serializedFilterObject = serializedFilterObject;
    }

    public void setIncludedBuckets(BitSet bitset) {
        this.includedBuckets = bitset;
    }

    public BitSet getIncludedBuckets() {
        return this.includedBuckets;
    }

    @Explain(displayName="buckets included", explainLevels={Explain.Level.EXTENDED})
    public String getIncludedBucketExplain() {
        if (this.includedBuckets == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i = 0; i < this.includedBuckets.size(); ++i) {
            if (!this.includedBuckets.get(i)) continue;
            sb.append(i);
            sb.append(',');
        }
        sb.append(String.format("] of %d", this.numBuckets));
        return sb.toString();
    }

    public int getNumBuckets() {
        return this.numBuckets;
    }

    public void setNumBuckets(int numBuckets) {
        this.numBuckets = numBuckets;
    }

    public boolean isNeedSkipHeaderFooters() {
        Map<String, String> params;
        boolean rtn = false;
        if (this.tableMetadata != null && this.tableMetadata.getTTable() != null && (params = this.tableMetadata.getTTable().getParameters()) != null) {
            String skipHVal = params.get("skip.header.line.count");
            int hcount = skipHVal == null ? 0 : Integer.parseInt(skipHVal);
            String skipFVal = params.get("skip.footer.line.count");
            int fcount = skipFVal == null ? 0 : Integer.parseInt(skipFVal);
            rtn = hcount != 0 || fcount != 0;
        }
        return rtn;
    }

    @Override
    @Explain(displayName="properties", explainLevels={Explain.Level.DEFAULT, Explain.Level.USER, Explain.Level.EXTENDED})
    public Map<String, String> getOpProps() {
        return this.opProps;
    }

    @Explain(vectorization=Explain.Vectorization.OPERATOR, displayName="TableScan Vectorization", explainLevels={Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public TableScanOperatorExplainVectorization getTableScanVectorization() {
        VectorTableScanDesc vectorTableScanDesc = (VectorTableScanDesc)this.getVectorDesc();
        if (vectorTableScanDesc == null) {
            return null;
        }
        return new TableScanOperatorExplainVectorization(this, vectorTableScanDesc);
    }

    public void setVectorized(boolean vectorized) {
        this.vectorized = vectorized;
    }

    public boolean isVectorized() {
        return this.vectorized;
    }

    @Override
    public boolean isSame(OperatorDesc other) {
        if (this.getClass().getName().equals(other.getClass().getName())) {
            TableScanDesc otherDesc = (TableScanDesc)other;
            return Objects.equals(this.getAlias(), otherDesc.getAlias()) && ExprNodeDescUtils.isSame(this.getFilterExpr(), otherDesc.getFilterExpr()) && this.getRowLimit() == otherDesc.getRowLimit() && this.isGatherStats() == otherDesc.isGatherStats();
        }
        return false;
    }

    public boolean isFullAcidTable() {
        return this.isTranscationalTable() && !this.getAcidOperationalProperties().isInsertOnly();
    }

    public class TableScanOperatorExplainVectorization
    extends OperatorExplainVectorization {
        private final TableScanDesc tableScanDesc;
        private final VectorTableScanDesc vectorTableScanDesc;

        public TableScanOperatorExplainVectorization(TableScanDesc tableScanDesc, VectorTableScanDesc vectorTableScanDesc) {
            super(vectorTableScanDesc, true);
            this.tableScanDesc = tableScanDesc;
            this.vectorTableScanDesc = vectorTableScanDesc;
        }

        @Explain(vectorization=Explain.Vectorization.DETAIL, displayName="vectorizationSchemaColumns", explainLevels={Explain.Level.DEFAULT, Explain.Level.EXTENDED})
        public String getSchemaColumns() {
            String[] projectedColumnNames = this.vectorTableScanDesc.getProjectedColumnNames();
            TypeInfo[] projectedColumnTypeInfos = this.vectorTableScanDesc.getProjectedColumnTypeInfos();
            int size = projectedColumnNames.length;
            int[] projectionColumns = new int[size];
            for (int i = 0; i < size; ++i) {
                projectionColumns[i] = i;
            }
            DataTypePhysicalVariation[] projectedColumnDataTypePhysicalVariations = this.vectorTableScanDesc.getProjectedColumnDataTypePhysicalVariations();
            return BaseWork.BaseExplainVectorization.getColumnAndTypes(projectionColumns, projectedColumnNames, projectedColumnTypeInfos, projectedColumnDataTypePhysicalVariations).toString();
        }
    }
}

