/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.wm;

import java.util.Objects;
import org.antlr.runtime.tree.Tree;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.ParseDriver;
import org.apache.hadoop.hive.ql.parse.ParseException;

public class Action {
    private final Type type;
    private final String poolName;

    public static Action fromMetastoreExpression(String metastoreActionExpression) {
        ParseDriver driver = new ParseDriver();
        ASTNode node = null;
        try {
            node = driver.parseTriggerActionExpression(metastoreActionExpression);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Invalid action expression: " + metastoreActionExpression, e);
        }
        if (node == null || node.getChildCount() != 2 || node.getChild(1).getType() != -1) {
            throw new IllegalArgumentException("Invalid action expression: " + metastoreActionExpression);
        }
        node = (ASTNode)node.getChild(0);
        switch (node.getType()) {
            case 172: {
                if (node.getChildCount() != 0) {
                    throw new IllegalArgumentException("Invalid KILL action");
                }
                return new Action(Type.KILL_QUERY);
            }
            case 201: {
                if (node.getChildCount() != 1) {
                    throw new IllegalArgumentException("Invalid move to action, expected poolPath");
                }
                Tree poolNode = node.getChild(0);
                StringBuilder poolPath = new StringBuilder(poolNode.getText());
                for (int i = 0; i < poolNode.getChildCount(); ++i) {
                    poolPath.append(poolNode.getChild(i).getText());
                }
                return new Action(Type.MOVE_TO_POOL, poolPath.toString());
            }
        }
        throw new IllegalArgumentException("Unhandled action expression, type: " + node.getType() + ": " + metastoreActionExpression);
    }

    public Action(Type type) {
        this(type, null);
    }

    public Action(Type type, String poolName) {
        this.type = type;
        if (type == Type.MOVE_TO_POOL && (poolName == null || poolName.trim().isEmpty())) {
            throw new IllegalArgumentException("Pool name cannot be null or empty for action type " + (Object)((Object)type));
        }
        this.poolName = poolName;
    }

    public Type getType() {
        return this.type;
    }

    public String getPoolName() {
        return this.poolName;
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof Action)) {
            return false;
        }
        if (other == this) {
            return true;
        }
        Action otherAction = (Action)other;
        return this.type == otherAction.type && Objects.equals(this.poolName, otherAction.poolName);
    }

    public int hashCode() {
        int hash = this.poolName == null ? 31 : 31 * this.poolName.hashCode();
        return hash += this.type == null ? 31 * hash : 31 * hash * this.type.hashCode();
    }

    public String toString() {
        return this.type.getDisplayName() + (this.poolName == null ? "" : " " + this.poolName);
    }

    public static enum Type {
        KILL_QUERY("KILL"),
        MOVE_TO_POOL("MOVE TO");

        String displayName;

        private Type(String displayName) {
            this.displayName = displayName;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String toString() {
            return this.displayName;
        }
    }
}

