/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.avro;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.avro.JsonProperties;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.schema.ConversionPatterns;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;

public class AvroSchemaConverter {
    public static final String ADD_LIST_ELEMENT_RECORDS = "parquet.avro.add-list-element-records";
    private static final boolean ADD_LIST_ELEMENT_RECORDS_DEFAULT = true;
    private final boolean assumeRepeatedIsListElement;
    private final boolean writeOldListStructure;
    private final boolean writeParquetUUID;
    private final boolean readInt96AsFixed;

    public AvroSchemaConverter() {
        this(true);
    }

    AvroSchemaConverter(boolean assumeRepeatedIsListElement) {
        this.assumeRepeatedIsListElement = assumeRepeatedIsListElement;
        this.writeOldListStructure = true;
        this.writeParquetUUID = false;
        this.readInt96AsFixed = false;
    }

    public AvroSchemaConverter(Configuration conf) {
        this.assumeRepeatedIsListElement = conf.getBoolean(ADD_LIST_ELEMENT_RECORDS, true);
        this.writeOldListStructure = conf.getBoolean("parquet.avro.write-old-list-structure", true);
        this.writeParquetUUID = conf.getBoolean("parquet.avro.write-parquet-uuid", false);
        this.readInt96AsFixed = conf.getBoolean("parquet.avro.readInt96AsFixed", false);
    }

    public static Schema getNonNull(Schema schema) {
        if (schema.getType().equals((Object)Schema.Type.UNION)) {
            List<Schema> schemas = schema.getTypes();
            if (schemas.size() == 2) {
                if (schemas.get(0).getType().equals((Object)Schema.Type.NULL)) {
                    return schemas.get(1);
                }
                if (schemas.get(1).getType().equals((Object)Schema.Type.NULL)) {
                    return schemas.get(0);
                }
                return schema;
            }
            return schema;
        }
        return schema;
    }

    public MessageType convert(Schema avroSchema) {
        if (!avroSchema.getType().equals((Object)Schema.Type.RECORD)) {
            throw new IllegalArgumentException("Avro schema must be a record.");
        }
        return new MessageType(avroSchema.getFullName(), this.convertFields(avroSchema.getFields()));
    }

    private List<Type> convertFields(List<Schema.Field> fields) {
        ArrayList<Type> types = new ArrayList<Type>();
        for (Schema.Field field : fields) {
            if (field.schema().getType().equals((Object)Schema.Type.NULL)) continue;
            types.add(this.convertField(field));
        }
        return types;
    }

    private Type convertField(String fieldName, Schema schema) {
        return this.convertField(fieldName, schema, Type.Repetition.REQUIRED);
    }

    private Type convertField(String fieldName, Schema schema, Type.Repetition repetition) {
        Types.PrimitiveBuilder builder;
        Schema.Type type = schema.getType();
        LogicalType logicalType = schema.getLogicalType();
        if (type.equals((Object)Schema.Type.BOOLEAN)) {
            builder = Types.primitive(PrimitiveType.PrimitiveTypeName.BOOLEAN, repetition);
        } else if (type.equals((Object)Schema.Type.INT)) {
            builder = Types.primitive(PrimitiveType.PrimitiveTypeName.INT32, repetition);
        } else if (type.equals((Object)Schema.Type.LONG)) {
            builder = Types.primitive(PrimitiveType.PrimitiveTypeName.INT64, repetition);
        } else if (type.equals((Object)Schema.Type.FLOAT)) {
            builder = Types.primitive(PrimitiveType.PrimitiveTypeName.FLOAT, repetition);
        } else if (type.equals((Object)Schema.Type.DOUBLE)) {
            builder = Types.primitive(PrimitiveType.PrimitiveTypeName.DOUBLE, repetition);
        } else if (type.equals((Object)Schema.Type.BYTES)) {
            builder = Types.primitive(PrimitiveType.PrimitiveTypeName.BINARY, repetition);
        } else if (type.equals((Object)Schema.Type.STRING)) {
            builder = logicalType != null && logicalType.getName().equals(LogicalTypes.uuid().getName()) && this.writeParquetUUID ? (Types.PrimitiveBuilder)Types.primitive(PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY, repetition).length(16) : (Types.PrimitiveBuilder)Types.primitive(PrimitiveType.PrimitiveTypeName.BINARY, repetition).as(LogicalTypeAnnotation.stringType());
        } else {
            if (type.equals((Object)Schema.Type.RECORD)) {
                return new GroupType(repetition, fieldName, this.convertFields(schema.getFields()));
            }
            if (type.equals((Object)Schema.Type.ENUM)) {
                builder = (Types.PrimitiveBuilder)Types.primitive(PrimitiveType.PrimitiveTypeName.BINARY, repetition).as(LogicalTypeAnnotation.enumType());
            } else {
                if (type.equals((Object)Schema.Type.ARRAY)) {
                    if (this.writeOldListStructure) {
                        return ConversionPatterns.listType(repetition, fieldName, this.convertField("array", schema.getElementType(), Type.Repetition.REPEATED));
                    }
                    return ConversionPatterns.listOfElements(repetition, fieldName, this.convertField("element", schema.getElementType()));
                }
                if (type.equals((Object)Schema.Type.MAP)) {
                    Type valType = this.convertField("value", schema.getValueType());
                    return ConversionPatterns.stringKeyMapType(repetition, fieldName, valType);
                }
                if (type.equals((Object)Schema.Type.FIXED)) {
                    builder = (Types.PrimitiveBuilder)Types.primitive(PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY, repetition).length(schema.getFixedSize());
                } else {
                    if (type.equals((Object)Schema.Type.UNION)) {
                        return this.convertUnion(fieldName, schema, repetition);
                    }
                    throw new UnsupportedOperationException("Cannot convert Avro type " + (Object)((Object)type));
                }
            }
        }
        if (logicalType != null) {
            if (logicalType instanceof LogicalTypes.Decimal) {
                LogicalTypes.Decimal decimal = (LogicalTypes.Decimal)logicalType;
                builder = (Types.PrimitiveBuilder)builder.as(LogicalTypeAnnotation.decimalType(decimal.getScale(), decimal.getPrecision()));
            } else {
                LogicalTypeAnnotation annotation = this.convertLogicalType(logicalType);
                if (annotation != null) {
                    builder.as(annotation);
                }
            }
        }
        return (Type)builder.named(fieldName);
    }

    private Type convertUnion(String fieldName, Schema schema, Type.Repetition repetition) {
        ArrayList<Schema> nonNullSchemas = new ArrayList<Schema>(schema.getTypes().size());
        boolean foundNullSchema = false;
        for (Schema childSchema : schema.getTypes()) {
            if (childSchema.getType().equals((Object)Schema.Type.NULL)) {
                foundNullSchema = true;
                if (Type.Repetition.REQUIRED != repetition) continue;
                repetition = Type.Repetition.OPTIONAL;
                continue;
            }
            nonNullSchemas.add(childSchema);
        }
        switch (nonNullSchemas.size()) {
            case 0: {
                throw new UnsupportedOperationException("Cannot convert Avro union of only nulls");
            }
            case 1: {
                return foundNullSchema ? this.convertField(fieldName, (Schema)nonNullSchemas.get(0), repetition) : this.convertUnionToGroupType(fieldName, repetition, nonNullSchemas);
            }
        }
        return this.convertUnionToGroupType(fieldName, repetition, nonNullSchemas);
    }

    private Type convertUnionToGroupType(String fieldName, Type.Repetition repetition, List<Schema> nonNullSchemas) {
        ArrayList<Type> unionTypes = new ArrayList<Type>(nonNullSchemas.size());
        int index = 0;
        for (Schema childSchema : nonNullSchemas) {
            unionTypes.add(this.convertField("member" + index++, childSchema, Type.Repetition.OPTIONAL));
        }
        return new GroupType(repetition, fieldName, unionTypes);
    }

    private Type convertField(Schema.Field field) {
        return this.convertField(field.name(), field.schema());
    }

    public Schema convert(MessageType parquetSchema) {
        return this.convertFields(parquetSchema.getName(), parquetSchema.getFields(), new HashMap<String, Integer>());
    }

    Schema convert(GroupType parquetSchema) {
        return this.convertFields(parquetSchema.getName(), parquetSchema.getFields(), new HashMap<String, Integer>());
    }

    private Schema convertFields(String name, List<Type> parquetFields, Map<String, Integer> names) {
        ArrayList<Schema.Field> fields = new ArrayList<Schema.Field>();
        Integer nameCount = names.merge(name, 1, (oldValue, value) -> oldValue + 1);
        for (Type parquetType : parquetFields) {
            Schema fieldSchema = this.convertField(parquetType, names);
            if (parquetType.isRepetition(Type.Repetition.REPEATED)) {
                throw new UnsupportedOperationException("REPEATED not supported outside LIST or MAP. Type: " + parquetType);
            }
            if (parquetType.isRepetition(Type.Repetition.OPTIONAL)) {
                fields.add(new Schema.Field(parquetType.getName(), AvroSchemaConverter.optional(fieldSchema), null, JsonProperties.NULL_VALUE));
                continue;
            }
            fields.add(new Schema.Field(parquetType.getName(), fieldSchema, null, null));
        }
        Schema schema = Schema.createRecord(name, null, nameCount > 1 ? name + nameCount : null, false);
        schema.setFields(fields);
        return schema;
    }

    private Schema convertField(final Type parquetType, final Map<String, Integer> names) {
        if (parquetType.isPrimitive()) {
            PrimitiveType asPrimitive = parquetType.asPrimitiveType();
            PrimitiveType.PrimitiveTypeName parquetPrimitiveTypeName = asPrimitive.getPrimitiveTypeName();
            final LogicalTypeAnnotation annotation = parquetType.getLogicalTypeAnnotation();
            Schema schema = parquetPrimitiveTypeName.convert(new PrimitiveType.PrimitiveTypeNameConverter<Schema, RuntimeException>(){

                @Override
                public Schema convertBOOLEAN(PrimitiveType.PrimitiveTypeName primitiveTypeName) {
                    return Schema.create(Schema.Type.BOOLEAN);
                }

                @Override
                public Schema convertINT32(PrimitiveType.PrimitiveTypeName primitiveTypeName) {
                    return Schema.create(Schema.Type.INT);
                }

                @Override
                public Schema convertINT64(PrimitiveType.PrimitiveTypeName primitiveTypeName) {
                    return Schema.create(Schema.Type.LONG);
                }

                @Override
                public Schema convertINT96(PrimitiveType.PrimitiveTypeName primitiveTypeName) {
                    if (AvroSchemaConverter.this.readInt96AsFixed) {
                        return Schema.createFixed("INT96", "INT96 represented as byte[12]", null, 12);
                    }
                    throw new IllegalArgumentException("INT96 is deprecated. As interim enable READ_INT96_AS_FIXED  flag to read as byte array.");
                }

                @Override
                public Schema convertFLOAT(PrimitiveType.PrimitiveTypeName primitiveTypeName) {
                    return Schema.create(Schema.Type.FLOAT);
                }

                @Override
                public Schema convertDOUBLE(PrimitiveType.PrimitiveTypeName primitiveTypeName) {
                    return Schema.create(Schema.Type.DOUBLE);
                }

                @Override
                public Schema convertFIXED_LEN_BYTE_ARRAY(PrimitiveType.PrimitiveTypeName primitiveTypeName) {
                    if (annotation instanceof LogicalTypeAnnotation.UUIDLogicalTypeAnnotation) {
                        return Schema.create(Schema.Type.STRING);
                    }
                    int size = parquetType.asPrimitiveType().getTypeLength();
                    return Schema.createFixed(parquetType.getName(), null, null, size);
                }

                @Override
                public Schema convertBINARY(PrimitiveType.PrimitiveTypeName primitiveTypeName) {
                    if (annotation instanceof LogicalTypeAnnotation.StringLogicalTypeAnnotation || annotation instanceof LogicalTypeAnnotation.EnumLogicalTypeAnnotation) {
                        return Schema.create(Schema.Type.STRING);
                    }
                    return Schema.create(Schema.Type.BYTES);
                }
            });
            LogicalType logicalType = this.convertLogicalType(annotation);
            if (!(logicalType == null || annotation instanceof LogicalTypeAnnotation.DecimalLogicalTypeAnnotation && parquetPrimitiveTypeName != PrimitiveType.PrimitiveTypeName.BINARY && parquetPrimitiveTypeName != PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY)) {
                schema = logicalType.addToSchema(schema);
            }
            return schema;
        }
        final GroupType parquetGroupType = parquetType.asGroupType();
        LogicalTypeAnnotation logicalTypeAnnotation = parquetGroupType.getLogicalTypeAnnotation();
        if (logicalTypeAnnotation != null) {
            return logicalTypeAnnotation.accept(new LogicalTypeAnnotation.LogicalTypeAnnotationVisitor<Schema>(){

                @Override
                public Optional<Schema> visit(LogicalTypeAnnotation.ListLogicalTypeAnnotation listLogicalType) {
                    if (parquetGroupType.getFieldCount() != 1) {
                        throw new UnsupportedOperationException("Invalid list type " + parquetGroupType);
                    }
                    Type repeatedType = parquetGroupType.getType(0);
                    if (!repeatedType.isRepetition(Type.Repetition.REPEATED)) {
                        throw new UnsupportedOperationException("Invalid list type " + parquetGroupType);
                    }
                    if (AvroSchemaConverter.this.isElementType(repeatedType, parquetGroupType.getName())) {
                        return Optional.of(Schema.createArray(AvroSchemaConverter.this.convertField(repeatedType, names)));
                    }
                    Type elementType = repeatedType.asGroupType().getType(0);
                    if (elementType.isRepetition(Type.Repetition.OPTIONAL)) {
                        return Optional.of(Schema.createArray(AvroSchemaConverter.optional(AvroSchemaConverter.this.convertField(elementType, names))));
                    }
                    return Optional.of(Schema.createArray(AvroSchemaConverter.this.convertField(elementType, names)));
                }

                @Override
                public Optional<Schema> visit(LogicalTypeAnnotation.MapKeyValueTypeAnnotation mapKeyValueLogicalType) {
                    return this.visitMapOrMapKeyValue();
                }

                @Override
                public Optional<Schema> visit(LogicalTypeAnnotation.MapLogicalTypeAnnotation mapLogicalType) {
                    return this.visitMapOrMapKeyValue();
                }

                private Optional<Schema> visitMapOrMapKeyValue() {
                    if (parquetGroupType.getFieldCount() != 1 || parquetGroupType.getType(0).isPrimitive()) {
                        throw new UnsupportedOperationException("Invalid map type " + parquetGroupType);
                    }
                    GroupType mapKeyValType = parquetGroupType.getType(0).asGroupType();
                    if (!mapKeyValType.isRepetition(Type.Repetition.REPEATED) || mapKeyValType.getFieldCount() != 2) {
                        throw new UnsupportedOperationException("Invalid map type " + parquetGroupType);
                    }
                    Type keyType = mapKeyValType.getType(0);
                    if (!(keyType.isPrimitive() && keyType.asPrimitiveType().getPrimitiveTypeName().equals((Object)PrimitiveType.PrimitiveTypeName.BINARY) && keyType.getLogicalTypeAnnotation().equals(LogicalTypeAnnotation.stringType()))) {
                        throw new IllegalArgumentException("Map key type must be binary (UTF8): " + keyType);
                    }
                    Type valueType = mapKeyValType.getType(1);
                    if (valueType.isRepetition(Type.Repetition.OPTIONAL)) {
                        return Optional.of(Schema.createMap(AvroSchemaConverter.optional(AvroSchemaConverter.this.convertField(valueType, names))));
                    }
                    return Optional.of(Schema.createMap(AvroSchemaConverter.this.convertField(valueType, names)));
                }

                @Override
                public Optional<Schema> visit(LogicalTypeAnnotation.EnumLogicalTypeAnnotation enumLogicalType) {
                    return Optional.of(Schema.create(Schema.Type.STRING));
                }
            }).orElseThrow(() -> new UnsupportedOperationException("Cannot convert Parquet type " + parquetType));
        }
        return this.convertFields(parquetGroupType.getName(), parquetGroupType.getFields(), names);
    }

    private LogicalTypeAnnotation convertLogicalType(LogicalType logicalType) {
        if (logicalType == null) {
            return null;
        }
        if (logicalType instanceof LogicalTypes.Decimal) {
            LogicalTypes.Decimal decimal = (LogicalTypes.Decimal)logicalType;
            return LogicalTypeAnnotation.decimalType(decimal.getScale(), decimal.getPrecision());
        }
        if (logicalType instanceof LogicalTypes.Date) {
            return LogicalTypeAnnotation.dateType();
        }
        if (logicalType instanceof LogicalTypes.TimeMillis) {
            return LogicalTypeAnnotation.timeType(true, LogicalTypeAnnotation.TimeUnit.MILLIS);
        }
        if (logicalType instanceof LogicalTypes.TimeMicros) {
            return LogicalTypeAnnotation.timeType(true, LogicalTypeAnnotation.TimeUnit.MICROS);
        }
        if (logicalType instanceof LogicalTypes.TimestampMillis) {
            return LogicalTypeAnnotation.timestampType(true, LogicalTypeAnnotation.TimeUnit.MILLIS);
        }
        if (logicalType instanceof LogicalTypes.TimestampMicros) {
            return LogicalTypeAnnotation.timestampType(true, LogicalTypeAnnotation.TimeUnit.MICROS);
        }
        if (logicalType.getName().equals(LogicalTypes.uuid().getName()) && this.writeParquetUUID) {
            return LogicalTypeAnnotation.uuidType();
        }
        return null;
    }

    private LogicalType convertLogicalType(LogicalTypeAnnotation annotation) {
        if (annotation == null) {
            return null;
        }
        return annotation.accept(new LogicalTypeAnnotation.LogicalTypeAnnotationVisitor<LogicalType>(){

            @Override
            public Optional<LogicalType> visit(LogicalTypeAnnotation.DecimalLogicalTypeAnnotation decimalLogicalType) {
                return Optional.of(LogicalTypes.decimal(decimalLogicalType.getPrecision(), decimalLogicalType.getScale()));
            }

            @Override
            public Optional<LogicalType> visit(LogicalTypeAnnotation.DateLogicalTypeAnnotation dateLogicalType) {
                return Optional.of(LogicalTypes.date());
            }

            @Override
            public Optional<LogicalType> visit(LogicalTypeAnnotation.TimeLogicalTypeAnnotation timeLogicalType) {
                LogicalTypeAnnotation.TimeUnit unit = timeLogicalType.getUnit();
                switch (unit) {
                    case MILLIS: {
                        return Optional.of(LogicalTypes.timeMillis());
                    }
                    case MICROS: {
                        return Optional.of(LogicalTypes.timeMicros());
                    }
                }
                return Optional.empty();
            }

            @Override
            public Optional<LogicalType> visit(LogicalTypeAnnotation.TimestampLogicalTypeAnnotation timestampLogicalType) {
                LogicalTypeAnnotation.TimeUnit unit = timestampLogicalType.getUnit();
                switch (unit) {
                    case MILLIS: {
                        return Optional.of(LogicalTypes.timestampMillis());
                    }
                    case MICROS: {
                        return Optional.of(LogicalTypes.timestampMicros());
                    }
                }
                return Optional.empty();
            }

            @Override
            public Optional<LogicalType> visit(LogicalTypeAnnotation.UUIDLogicalTypeAnnotation uuidLogicalType) {
                return Optional.of(LogicalTypes.uuid());
            }
        }).orElse(null);
    }

    private boolean isElementType(Type repeatedType, String parentName) {
        return repeatedType.isPrimitive() || repeatedType.asGroupType().getFieldCount() > 1 || repeatedType.asGroupType().getType(0).isRepetition(Type.Repetition.REPEATED) || repeatedType.getName().equals("array") || repeatedType.getName().equals(parentName + "_tuple") || this.assumeRepeatedIsListElement;
    }

    private static Schema optional(Schema original) {
        return Schema.createUnion(Arrays.asList(Schema.create(Schema.Type.NULL), original));
    }
}

