/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.hadoop;

import com.facebook.presto.hive.$internal.org.slf4j.Logger;
import com.facebook.presto.hive.$internal.org.slf4j.LoggerFactory;
import java.util.LinkedHashMap;
import java.util.Map;

final class LruCache<K, V extends Value<K, V>> {
    private static final Logger LOG = LoggerFactory.getLogger(LruCache.class);
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private final LinkedHashMap<K, V> cacheMap;

    public LruCache(int maxSize) {
        this(maxSize, 0.75f, true);
    }

    public LruCache(final int maxSize, float loadFactor, boolean accessOrder) {
        int initialCapacity = Math.round((float)maxSize / loadFactor);
        this.cacheMap = new LinkedHashMap<K, V>(initialCapacity, loadFactor, accessOrder){

            @Override
            public boolean removeEldestEntry(Map.Entry<K, V> eldest) {
                boolean result;
                boolean bl = result = this.size() > maxSize;
                if (result && LOG.isDebugEnabled()) {
                    LOG.debug("Removing eldest entry in cache: " + eldest.getKey());
                }
                return result;
            }
        };
    }

    public V remove(K key) {
        Value oldValue = (Value)this.cacheMap.remove(key);
        if (oldValue != null) {
            LOG.debug("Removed cache entry for '{}'", (Object)key);
        }
        return (V)oldValue;
    }

    public void put(K key, V newValue) {
        if (newValue == null || !newValue.isCurrent(key)) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("Ignoring new cache entry for '{}' because it is {}", (Object)key, (Object)(newValue == null ? "null" : "not current"));
            }
            return;
        }
        Value oldValue = (Value)this.cacheMap.get(key);
        if (oldValue != null && oldValue.isNewerThan(newValue)) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("Ignoring new cache entry for '{}' because existing cache entry is newer", (Object)key);
            }
            return;
        }
        oldValue = (Value)this.cacheMap.put(key, newValue);
        if (LOG.isDebugEnabled()) {
            if (oldValue == null) {
                LOG.debug("Added new cache entry for '{}'", (Object)key);
            } else {
                LOG.debug("Overwrote existing cache entry for '{}'", (Object)key);
            }
        }
    }

    public void clear() {
        this.cacheMap.clear();
    }

    public V getCurrentValue(K key) {
        Value value = (Value)this.cacheMap.get(key);
        LOG.debug("Value for '{}' {} in cache", (Object)key, (Object)(value == null ? "not " : ""));
        if (value != null && !value.isCurrent(key)) {
            this.remove(key);
            return null;
        }
        return (V)value;
    }

    public int size() {
        return this.cacheMap.size();
    }

    static interface Value<K, V> {
        public boolean isCurrent(K var1);

        public boolean isNewerThan(V var1);
    }
}

