/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.functions.type;

import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.CharType;
import com.facebook.presto.common.type.DecimalType;
import com.facebook.presto.common.type.MapType;
import com.facebook.presto.common.type.RowType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.hive.functions.HiveFunctionErrorCode;
import io.airlift.slice.Slice;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.common.type.HiveChar;
import org.apache.hadoop.hive.common.type.HiveVarchar;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;

public final class HiveTypes {
    private HiveTypes() {
    }

    public static HiveVarchar createHiveVarChar(String s) {
        return new HiveVarchar(s, s.length());
    }

    public static HiveVarchar createHiveVarChar(Slice slice) {
        String str = slice.toStringUtf8();
        return new HiveVarchar(str, str.length());
    }

    public static HiveChar createHiveChar(String s) {
        return new HiveChar(s, s.length());
    }

    public static HiveChar createHiveChar(Slice slice) {
        String str = slice.toStringUtf8();
        return new HiveChar(str, str.length());
    }

    public static TypeInfo toTypeInfo(Type type) {
        TypeSignature signature = type.getTypeSignature();
        switch (type.getTypeSignature().getBase()) {
            case "bigint": {
                return TypeInfoFactory.longTypeInfo;
            }
            case "integer": {
                return TypeInfoFactory.intTypeInfo;
            }
            case "smallint": {
                return TypeInfoFactory.shortTypeInfo;
            }
            case "tinyint": {
                return TypeInfoFactory.byteTypeInfo;
            }
            case "boolean": {
                return TypeInfoFactory.booleanTypeInfo;
            }
            case "date": {
                return TypeInfoFactory.dateTypeInfo;
            }
            case "decimal": {
                return HiveTypes.toDecimalTypeInfo(type);
            }
            case "real": {
                return TypeInfoFactory.floatTypeInfo;
            }
            case "double": {
                return TypeInfoFactory.doubleTypeInfo;
            }
            case "timestamp": {
                return TypeInfoFactory.timestampTypeInfo;
            }
            case "varbinary": {
                return TypeInfoFactory.binaryTypeInfo;
            }
            case "varchar": {
                return HiveTypes.toVarcharTypeInfo(type);
            }
            case "char": {
                return HiveTypes.toCharTypeInfo(type);
            }
            case "row": {
                return HiveTypes.toStructTypeInfo(type);
            }
            case "array": {
                return HiveTypes.toListTypeInfo(type);
            }
            case "map": {
                return HiveTypes.toMapTypeInfo(type);
            }
        }
        throw HiveFunctionErrorCode.unsupportedType(signature);
    }

    private static TypeInfo toDecimalTypeInfo(Type type) {
        if (type instanceof DecimalType) {
            DecimalType decimal = (DecimalType)type;
            return TypeInfoFactory.getDecimalTypeInfo((int)decimal.getPrecision(), (int)decimal.getScale());
        }
        throw HiveFunctionErrorCode.unsupportedType(type);
    }

    private static TypeInfo toVarcharTypeInfo(Type type) {
        if (type instanceof VarcharType) {
            VarcharType varchar = (VarcharType)type;
            if (varchar.isUnbounded()) {
                return TypeInfoFactory.varcharTypeInfo;
            }
            return TypeInfoFactory.getVarcharTypeInfo((int)varchar.getLengthSafe());
        }
        throw HiveFunctionErrorCode.unsupportedType(type);
    }

    private static TypeInfo toCharTypeInfo(Type type) {
        if (type instanceof CharType) {
            CharType chars = (CharType)type;
            return TypeInfoFactory.getCharTypeInfo((int)chars.getLength());
        }
        throw HiveFunctionErrorCode.unsupportedType(type);
    }

    private static TypeInfo toStructTypeInfo(Type type) {
        if (type instanceof RowType) {
            RowType row = (RowType)type;
            List fields = row.getFields();
            ArrayList<String> fieldNames = new ArrayList<String>(fields.size());
            ArrayList<TypeInfo> fieldTypes = new ArrayList<TypeInfo>(fields.size());
            for (int i = 0; i < fields.size(); ++i) {
                RowType.Field field = (RowType.Field)fields.get(i);
                fieldNames.add(field.getName().orElse("col" + i));
                fieldTypes.add(HiveTypes.toTypeInfo(field.getType()));
            }
            return TypeInfoFactory.getStructTypeInfo(fieldNames, fieldTypes);
        }
        throw HiveFunctionErrorCode.unsupportedType(type);
    }

    private static TypeInfo toListTypeInfo(Type type) {
        if (type instanceof ArrayType) {
            ArrayType array = (ArrayType)type;
            Type element = array.getElementType();
            return TypeInfoFactory.getListTypeInfo((TypeInfo)HiveTypes.toTypeInfo(element));
        }
        throw HiveFunctionErrorCode.unsupportedType(type);
    }

    private static TypeInfo toMapTypeInfo(Type type) {
        if (type instanceof MapType) {
            MapType map = (MapType)type;
            return TypeInfoFactory.getMapTypeInfo((TypeInfo)HiveTypes.toTypeInfo(map.getKeyType()), (TypeInfo)HiveTypes.toTypeInfo(map.getValueType()));
        }
        throw HiveFunctionErrorCode.unsupportedType(type);
    }
}

