/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hadoop.$internal.com.microsoft.azure.storage;

import com.facebook.presto.hadoop.$internal.com.microsoft.azure.storage.core.BaseRequest;
import com.facebook.presto.hadoop.$internal.com.microsoft.azure.storage.core.Utility;
import java.net.HttpURLConnection;
import java.util.Date;

public final class AccessCondition {
    private String leaseID = null;
    private String etag = null;
    private Date ifModifiedSinceDate = null;
    private Date ifUnmodifiedSinceDate = null;
    private String ifMatchHeaderType = null;

    public static AccessCondition generateEmptyCondition() {
        return new AccessCondition();
    }

    public static AccessCondition generateIfMatchCondition(String etag) {
        AccessCondition retCondition = new AccessCondition();
        retCondition.setIfMatch(etag);
        return retCondition;
    }

    public static AccessCondition generateIfModifiedSinceCondition(Date lastMotified) {
        AccessCondition retCondition = new AccessCondition();
        retCondition.ifModifiedSinceDate = lastMotified;
        return retCondition;
    }

    public static AccessCondition generateIfNoneMatchCondition(String etag) {
        AccessCondition retCondition = new AccessCondition();
        retCondition.setIfNoneMatch(etag);
        return retCondition;
    }

    public static AccessCondition generateIfNotModifiedSinceCondition(Date lastMotified) {
        AccessCondition retCondition = new AccessCondition();
        retCondition.ifUnmodifiedSinceDate = lastMotified;
        return retCondition;
    }

    public static AccessCondition generateLeaseCondition(String leaseID) {
        AccessCondition retCondition = new AccessCondition();
        retCondition.leaseID = leaseID;
        return retCondition;
    }

    public void applyConditionToRequest(HttpURLConnection request) {
        this.applyConditionToRequest(request, false);
    }

    public void applyConditionToRequest(HttpURLConnection request, boolean useSourceAccessHeaders) {
        if (useSourceAccessHeaders) {
            if (!Utility.isNullOrEmpty(this.leaseID)) {
                request.setRequestProperty("x-ms-source-lease-id", this.leaseID);
            }
            if (this.ifModifiedSinceDate != null) {
                request.setRequestProperty("x-ms-source-if-modified-since", Utility.getGMTTime(this.ifModifiedSinceDate));
            }
            if (this.ifUnmodifiedSinceDate != null) {
                request.setRequestProperty("x-ms-source-if-unmodified-since", Utility.getGMTTime(this.ifUnmodifiedSinceDate));
            }
            if (!Utility.isNullOrEmpty(this.etag)) {
                if (this.ifMatchHeaderType.equals("If-Match")) {
                    request.setRequestProperty("x-ms-source-if-match", this.etag);
                } else if (this.ifMatchHeaderType.equals("If-None-Match")) {
                    request.setRequestProperty("x-ms-source-if-none-match", this.etag);
                }
            }
        } else {
            if (!Utility.isNullOrEmpty(this.leaseID)) {
                BaseRequest.addLeaseId(request, this.leaseID);
            }
            if (this.ifModifiedSinceDate != null) {
                request.setRequestProperty("If-Modified-Since", Utility.getGMTTime(this.ifModifiedSinceDate));
            }
            if (this.ifUnmodifiedSinceDate != null) {
                request.setRequestProperty("If-Unmodified-Since", Utility.getGMTTime(this.ifUnmodifiedSinceDate));
            }
            if (!Utility.isNullOrEmpty(this.etag)) {
                request.setRequestProperty(this.ifMatchHeaderType, this.etag);
            }
        }
    }

    public String getIfMatch() {
        return this.ifMatchHeaderType.equals("If-Match") ? this.etag : null;
    }

    public Date getIfModifiedSinceDate() {
        return this.ifModifiedSinceDate;
    }

    public String getIfNoneMatch() {
        return this.ifMatchHeaderType.equals("If-None-Match") ? this.etag : null;
    }

    public Date getIfUnmodifiedSinceDate() {
        return this.ifUnmodifiedSinceDate;
    }

    public String getLeaseID() {
        return this.leaseID;
    }

    public void setIfMatch(String etag) {
        this.etag = AccessCondition.normalizeEtag(etag);
        this.ifMatchHeaderType = "If-Match";
    }

    public void setIfModifiedSinceDate(Date ifModifiedSinceDate) {
        this.ifModifiedSinceDate = ifModifiedSinceDate;
    }

    public void setIfNoneMatch(String etag) {
        this.etag = AccessCondition.normalizeEtag(etag);
        this.ifMatchHeaderType = "If-None-Match";
    }

    public void setIfUnmodifiedSinceDate(Date ifUnmodifiedSinceDate) {
        this.ifUnmodifiedSinceDate = ifUnmodifiedSinceDate;
    }

    public void setLeaseID(String leaseID) {
        this.leaseID = leaseID;
    }

    public boolean verifyConditional(String etag, Date lastModified) {
        if (this.ifModifiedSinceDate != null && !lastModified.after(this.ifModifiedSinceDate)) {
            return false;
        }
        if (this.ifUnmodifiedSinceDate != null && lastModified.after(this.ifUnmodifiedSinceDate)) {
            return false;
        }
        return Utility.isNullOrEmpty(this.etag) || !(this.ifMatchHeaderType.equals("If-Match") ? !this.etag.equals(etag) && !this.etag.equals("*") : this.ifMatchHeaderType.equals("If-None-Match") && this.etag.equals(etag));
    }

    private static String normalizeEtag(String inTag) {
        if (Utility.isNullOrEmpty(inTag) || inTag.equals("*")) {
            return inTag;
        }
        if (inTag.startsWith("\"") && inTag.endsWith("\"")) {
            return inTag;
        }
        return String.format("\"%s\"", inTag);
    }
}

