/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hadoop.$internal.com.microsoft.azure.storage;

import com.facebook.presto.hadoop.$internal.com.microsoft.azure.storage.LocationMode;
import com.facebook.presto.hadoop.$internal.com.microsoft.azure.storage.StorageLocation;
import com.facebook.presto.hadoop.$internal.com.microsoft.azure.storage.core.Utility;
import java.net.URI;

public class StorageUri {
    private URI primaryUri;
    private URI secondaryUri;

    private static boolean AreUrisEqual(URI uri1, URI uri2) {
        return uri1 == null ? uri2 == null : uri1.equals(uri2);
    }

    private static void AssertAbsoluteUri(URI uri) {
        if (uri != null && !uri.isAbsolute()) {
            String errorMessage = String.format(Utility.LOCALE_US, "Address %s is a relative address. Only absolute addresses are permitted.", uri.toString());
            throw new IllegalArgumentException(errorMessage);
        }
    }

    public StorageUri(URI primaryUri) {
        this(primaryUri, null);
    }

    public StorageUri(URI primaryUri, URI secondaryUri) {
        if (primaryUri == null && secondaryUri == null) {
            throw new IllegalArgumentException("Primary and secondary location URIs in a StorageUri must not both be null.");
        }
        if (primaryUri != null && secondaryUri != null) {
            if (primaryUri.getQuery() == null && secondaryUri.getQuery() != null || primaryUri.getQuery() != null && !primaryUri.getQuery().equals(secondaryUri.getQuery())) {
                throw new IllegalArgumentException("Primary and secondary location URIs in a StorageUri must point to the same resource.");
            }
            boolean primaryPathStyle = Utility.determinePathStyleFromUri(primaryUri);
            boolean secondaryPathStyle = Utility.determinePathStyleFromUri(secondaryUri);
            if (!primaryPathStyle && !secondaryPathStyle) {
                if (primaryUri.getPath() == null && secondaryUri.getPath() != null || primaryUri.getPath() != null && !primaryUri.getPath().equals(secondaryUri.getPath())) {
                    throw new IllegalArgumentException("Primary and secondary location URIs in a StorageUri must point to the same resource.");
                }
            } else {
                int maxPrimaryPathSegments = primaryPathStyle ? 3 : 2;
                int maxSecondaryPathSegments = secondaryPathStyle ? 3 : 2;
                String[] primaryPathSegments = primaryUri.getPath().split("/", maxPrimaryPathSegments);
                String[] secondaryPathSegments = secondaryUri.getPath().split("/", maxSecondaryPathSegments);
                String primaryPath = "";
                if (primaryPathSegments.length == maxPrimaryPathSegments) {
                    primaryPath = primaryPathSegments[primaryPathSegments.length - 1];
                }
                String secondaryPath = "";
                if (secondaryPathSegments.length == maxSecondaryPathSegments) {
                    secondaryPath = secondaryPathSegments[secondaryPathSegments.length - 1];
                }
                if (!primaryPath.equals(secondaryPath)) {
                    throw new IllegalArgumentException("Primary and secondary location URIs in a StorageUri must point to the same resource.");
                }
            }
        }
        this.setPrimaryUri(primaryUri);
        this.setSecondaryUri(secondaryUri);
    }

    public boolean equals(Object obj) {
        return this.equals((StorageUri)obj);
    }

    public boolean equals(StorageUri other) {
        return other != null && StorageUri.AreUrisEqual(this.primaryUri, other.primaryUri) && StorageUri.AreUrisEqual(this.secondaryUri, other.secondaryUri);
    }

    public URI getPrimaryUri() {
        return this.primaryUri;
    }

    public URI getSecondaryUri() {
        return this.secondaryUri;
    }

    public URI getUri(StorageLocation location) {
        switch (location) {
            case PRIMARY: {
                return this.primaryUri;
            }
            case SECONDARY: {
                return this.secondaryUri;
            }
        }
        throw new IllegalArgumentException(String.format(Utility.LOCALE_US, "The argument is out of range. Argument name: %s, Value passed: %s.", "location", location.toString()));
    }

    public int hashCode() {
        int hash1 = this.primaryUri != null ? this.primaryUri.hashCode() : 0;
        int hash2 = this.secondaryUri != null ? this.secondaryUri.hashCode() : 0;
        return hash1 ^ hash2;
    }

    private void setPrimaryUri(URI primaryUri) {
        StorageUri.AssertAbsoluteUri(primaryUri);
        this.primaryUri = primaryUri;
    }

    private void setSecondaryUri(URI secondaryUri) {
        StorageUri.AssertAbsoluteUri(secondaryUri);
        this.secondaryUri = secondaryUri;
    }

    public String toString() {
        return String.format(Utility.LOCALE_US, "Primary = '%s'; Secondary = '%s'", this.primaryUri, this.secondaryUri);
    }

    public boolean validateLocationMode(LocationMode mode) {
        switch (mode) {
            case PRIMARY_ONLY: {
                return this.primaryUri != null;
            }
            case SECONDARY_ONLY: {
                return this.secondaryUri != null;
            }
        }
        return this.primaryUri != null && this.secondaryUri != null;
    }

    public boolean isAbsolute() {
        if (this.secondaryUri == null) {
            return this.primaryUri.isAbsolute();
        }
        return this.primaryUri.isAbsolute() && this.secondaryUri.isAbsolute();
    }

    public String getQuery() {
        return this.primaryUri.getQuery();
    }
}

