/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hadoop.$internal.com.microsoft.azure.storage.file;

import com.facebook.presto.hadoop.$internal.com.microsoft.azure.storage.DoesServiceRequest;
import com.facebook.presto.hadoop.$internal.com.microsoft.azure.storage.LocationMode;
import com.facebook.presto.hadoop.$internal.com.microsoft.azure.storage.OperationContext;
import com.facebook.presto.hadoop.$internal.com.microsoft.azure.storage.RequestOptions;
import com.facebook.presto.hadoop.$internal.com.microsoft.azure.storage.ResultContinuation;
import com.facebook.presto.hadoop.$internal.com.microsoft.azure.storage.ResultContinuationType;
import com.facebook.presto.hadoop.$internal.com.microsoft.azure.storage.ResultSegment;
import com.facebook.presto.hadoop.$internal.com.microsoft.azure.storage.RetryExponentialRetry;
import com.facebook.presto.hadoop.$internal.com.microsoft.azure.storage.ServiceClient;
import com.facebook.presto.hadoop.$internal.com.microsoft.azure.storage.StorageCredentials;
import com.facebook.presto.hadoop.$internal.com.microsoft.azure.storage.StorageException;
import com.facebook.presto.hadoop.$internal.com.microsoft.azure.storage.StorageUri;
import com.facebook.presto.hadoop.$internal.com.microsoft.azure.storage.core.ExecutionEngine;
import com.facebook.presto.hadoop.$internal.com.microsoft.azure.storage.core.LazySegmentedIterable;
import com.facebook.presto.hadoop.$internal.com.microsoft.azure.storage.core.ListResponse;
import com.facebook.presto.hadoop.$internal.com.microsoft.azure.storage.core.ListingContext;
import com.facebook.presto.hadoop.$internal.com.microsoft.azure.storage.core.SegmentedStorageRequest;
import com.facebook.presto.hadoop.$internal.com.microsoft.azure.storage.core.StorageRequest;
import com.facebook.presto.hadoop.$internal.com.microsoft.azure.storage.core.Utility;
import com.facebook.presto.hadoop.$internal.com.microsoft.azure.storage.file.CloudFileShare;
import com.facebook.presto.hadoop.$internal.com.microsoft.azure.storage.file.FileRequest;
import com.facebook.presto.hadoop.$internal.com.microsoft.azure.storage.file.FileRequestOptions;
import com.facebook.presto.hadoop.$internal.com.microsoft.azure.storage.file.ShareListHandler;
import com.facebook.presto.hadoop.$internal.com.microsoft.azure.storage.file.ShareListingDetails;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;

public final class CloudFileClient
extends ServiceClient {
    private FileRequestOptions defaultRequestOptions = new FileRequestOptions();

    public CloudFileClient(URI baseUri, StorageCredentials credentials) {
        this(new StorageUri(baseUri), credentials);
    }

    public CloudFileClient(StorageUri storageUri, StorageCredentials credentials) {
        super(storageUri, credentials);
        this.defaultRequestOptions.setLocationMode(LocationMode.PRIMARY_ONLY);
        this.defaultRequestOptions.setRetryPolicyFactory(new RetryExponentialRetry());
        this.defaultRequestOptions.setConcurrentRequestCount(1);
    }

    public CloudFileShare getShareReference(String shareName) throws URISyntaxException, StorageException {
        Utility.assertNotNullOrEmpty("shareName", shareName);
        return new CloudFileShare(shareName, this);
    }

    @DoesServiceRequest
    public Iterable<CloudFileShare> listShares() {
        return this.listSharesWithPrefix(null, ShareListingDetails.NONE, null, null);
    }

    @DoesServiceRequest
    public Iterable<CloudFileShare> listShares(String prefix) {
        return this.listSharesWithPrefix(prefix, ShareListingDetails.NONE, null, null);
    }

    @DoesServiceRequest
    public Iterable<CloudFileShare> listShares(String prefix, ShareListingDetails detailsIncluded, FileRequestOptions options, OperationContext opContext) {
        return this.listSharesWithPrefix(prefix, detailsIncluded, options, opContext);
    }

    @DoesServiceRequest
    public ResultSegment<CloudFileShare> listSharesSegmented() throws StorageException {
        return this.listSharesSegmented(null, ShareListingDetails.NONE, null, null, null, null);
    }

    @DoesServiceRequest
    public ResultSegment<CloudFileShare> listSharesSegmented(String prefix) throws StorageException {
        return this.listSharesWithPrefixSegmented(prefix, ShareListingDetails.NONE, null, null, null, null);
    }

    @DoesServiceRequest
    public ResultSegment<CloudFileShare> listSharesSegmented(String prefix, ShareListingDetails detailsIncluded, Integer maxResults, ResultContinuation continuationToken, FileRequestOptions options, OperationContext opContext) throws StorageException {
        return this.listSharesWithPrefixSegmented(prefix, detailsIncluded, maxResults, continuationToken, options, opContext);
    }

    private Iterable<CloudFileShare> listSharesWithPrefix(String prefix, ShareListingDetails detailsIncluded, FileRequestOptions options, OperationContext opContext) {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = FileRequestOptions.applyDefaults(options, this);
        SegmentedStorageRequest segmentedRequest = new SegmentedStorageRequest();
        return new LazySegmentedIterable<CloudFileClient, Object, CloudFileShare>(this.listSharesWithPrefixSegmentedImpl(prefix, detailsIncluded, null, options, segmentedRequest), this, null, options.getRetryPolicyFactory(), opContext);
    }

    private ResultSegment<CloudFileShare> listSharesWithPrefixSegmented(String prefix, ShareListingDetails detailsIncluded, Integer maxResults, ResultContinuation continuationToken, FileRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = FileRequestOptions.applyDefaults(options, this);
        Utility.assertContinuationType(continuationToken, ResultContinuationType.SHARE);
        SegmentedStorageRequest segmentedRequest = new SegmentedStorageRequest();
        segmentedRequest.setToken(continuationToken);
        return ExecutionEngine.executeWithRetry(this, null, this.listSharesWithPrefixSegmentedImpl(prefix, detailsIncluded, maxResults, options, segmentedRequest), options.getRetryPolicyFactory(), opContext);
    }

    private StorageRequest<CloudFileClient, Void, ResultSegment<CloudFileShare>> listSharesWithPrefixSegmentedImpl(String prefix, final ShareListingDetails detailsIncluded, Integer maxResults, final FileRequestOptions options, final SegmentedStorageRequest segmentedRequest) {
        Utility.assertContinuationType(segmentedRequest.getToken(), ResultContinuationType.SHARE);
        final ListingContext listingContext = new ListingContext(prefix, maxResults);
        StorageRequest<CloudFileClient, Void, ResultSegment<CloudFileShare>> getRequest = new StorageRequest<CloudFileClient, Void, ResultSegment<CloudFileShare>>((RequestOptions)options, this.getStorageUri()){

            @Override
            public void setRequestLocationMode() {
                this.setRequestLocationMode(Utility.getListingLocationMode(segmentedRequest.getToken()));
            }

            @Override
            public HttpURLConnection buildRequest(CloudFileClient client, Void parentObject, OperationContext context) throws Exception {
                listingContext.setMarker(segmentedRequest.getToken() != null ? segmentedRequest.getToken().getNextMarker() : null);
                return FileRequest.listShares(client.getCredentials().transformUri(client.getStorageUri()).getUri(this.getCurrentLocation()), options, context, listingContext, detailsIncluded);
            }

            @Override
            public void signRequest(HttpURLConnection connection, CloudFileClient client, OperationContext context) throws Exception {
                StorageRequest.signBlobQueueAndFileRequest(connection, client, -1L, null);
            }

            @Override
            public ResultSegment<CloudFileShare> preProcessResponse(Void parentObject, CloudFileClient client, OperationContext context) throws Exception {
                if (this.getResult().getStatusCode() != 200) {
                    this.setNonExceptionedRetryableFailure(true);
                }
                return null;
            }

            @Override
            public ResultSegment<CloudFileShare> postProcessResponse(HttpURLConnection connection, Void share, CloudFileClient client, OperationContext context, ResultSegment<CloudFileShare> storageObject) throws Exception {
                ListResponse<CloudFileShare> response = ShareListHandler.getShareList(this.getConnection().getInputStream(), client);
                ResultContinuation newToken = null;
                if (response.getNextMarker() != null) {
                    newToken = new ResultContinuation();
                    newToken.setNextMarker(response.getNextMarker());
                    newToken.setContinuationType(ResultContinuationType.SHARE);
                    newToken.setTargetLocation(this.getResult().getTargetLocation());
                }
                ResultSegment<CloudFileShare> resSegment = new ResultSegment<CloudFileShare>(response.getResults(), response.getMaxResults(), newToken);
                segmentedRequest.setToken(resSegment.getContinuationToken());
                return resSegment;
            }
        };
        return getRequest;
    }

    @Override
    public FileRequestOptions getDefaultRequestOptions() {
        return this.defaultRequestOptions;
    }

    public void setDefaultRequestOptions(FileRequestOptions defaultRequestOptions) {
        Utility.assertNotNull("defaultRequestOptions", defaultRequestOptions);
        this.defaultRequestOptions = defaultRequestOptions;
    }

    @Override
    protected boolean isUsePathStyleUris() {
        return super.isUsePathStyleUris();
    }
}

