/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hadoop.$internal.com.microsoft.azure.storage.table;

import com.facebook.presto.hadoop.$internal.com.fasterxml.jackson.core.JsonParseException;
import com.facebook.presto.hadoop.$internal.com.microsoft.azure.storage.RequestResult;
import com.facebook.presto.hadoop.$internal.com.microsoft.azure.storage.StorageException;
import com.facebook.presto.hadoop.$internal.com.microsoft.azure.storage.StorageExtendedErrorInformation;
import com.facebook.presto.hadoop.$internal.com.microsoft.azure.storage.table.TableOperation;
import com.facebook.presto.hadoop.$internal.com.microsoft.azure.storage.table.TablePayloadFormat;
import com.facebook.presto.hadoop.$internal.com.microsoft.azure.storage.table.TableStorageErrorDeserializer;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import javax.xml.stream.XMLStreamException;

public final class TableServiceException
extends StorageException {
    private static final long serialVersionUID = 6037366449663934891L;
    private TableOperation operation;
    private boolean retryable = false;

    protected static TableServiceException generateTableServiceException(boolean retryable, RequestResult res, TableOperation op, InputStream inStream, TablePayloadFormat format) {
        TableServiceException retryableException = new TableServiceException(res.getStatusCode(), res.getStatusMessage(), op, new InputStreamReader(inStream), format);
        retryableException.retryable = retryable;
        return retryableException;
    }

    public TableServiceException(String errorCode, String message, int statusCode, StorageExtendedErrorInformation extendedErrorInfo, Exception innerException) {
        super(errorCode, message, statusCode, extendedErrorInfo, innerException);
    }

    protected TableServiceException(int httpStatusCode, String message, TableOperation operation, Reader reader, TablePayloadFormat format) {
        super(null, message, httpStatusCode, null, null);
        this.operation = operation;
        if (reader != null) {
            try {
                this.extendedErrorInformation = TableStorageErrorDeserializer.getExtendedErrorInformation(reader, format);
                this.errorCode = this.extendedErrorInformation.getErrorCode();
            }
            catch (XMLStreamException e) {
            }
            catch (JsonParseException e) {
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    public TableOperation getOperation() {
        return this.operation;
    }

    public boolean isRetryable() {
        return this.retryable;
    }

    protected void setOperation(TableOperation operation) {
        this.operation = operation;
    }

    protected void setRetryable(boolean retryable) {
        this.retryable = retryable;
    }
}

