/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.IOException;
import java.util.EnumSet;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FilterFileSystem;
import org.apache.hadoop.fs.InputStreamWrapper;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.OutputStreamWrapper;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.util.Progressable;

public class PrestoFilterFileSystemWrapper
extends FilterFileSystem {
    public PrestoFilterFileSystemWrapper(FileSystem fs) {
        super(fs);
    }

    @Override
    public FSDataInputStream open(Path f, int bufferSize) throws IOException {
        return new InputStreamWrapper(this.getRawFileSystem().open(f, bufferSize), this);
    }

    @Override
    public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) throws IOException {
        return new OutputStreamWrapper(this.getRawFileSystem().append(f, bufferSize, progress), this);
    }

    @Override
    public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        return new OutputStreamWrapper(this.getRawFileSystem().create(f, permission, overwrite, bufferSize, replication, blockSize, progress), this);
    }

    @Override
    public FSDataOutputStream create(Path f, FsPermission permission, EnumSet<CreateFlag> flags, int bufferSize, short replication, long blockSize, Progressable progress, Options.ChecksumOpt checksumOpt) throws IOException {
        return new OutputStreamWrapper(this.getRawFileSystem().create(f, permission, flags, bufferSize, replication, blockSize, progress, checksumOpt), this);
    }

    @Override
    public FSDataOutputStream createNonRecursive(Path f, FsPermission permission, EnumSet<CreateFlag> flags, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        return new OutputStreamWrapper(this.getRawFileSystem().createNonRecursive(f, permission, flags, bufferSize, replication, blockSize, progress), this);
    }
}

