/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azure;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.azure.BlobMaterialization;
import org.apache.hadoop.fs.permission.PermissionStatus;

@InterfaceAudience.Private
class FileMetadata {
    private final String key;
    private final long length;
    private final long lastModified;
    private final boolean isDir;
    private final PermissionStatus permissionStatus;
    private final BlobMaterialization blobMaterialization;

    public FileMetadata(String key, long length, long lastModified, PermissionStatus permissionStatus) {
        this.key = key;
        this.length = length;
        this.lastModified = lastModified;
        this.isDir = false;
        this.permissionStatus = permissionStatus;
        this.blobMaterialization = BlobMaterialization.Explicit;
    }

    public FileMetadata(String key, long lastModified, PermissionStatus permissionStatus, BlobMaterialization blobMaterialization) {
        this.key = key;
        this.isDir = true;
        this.length = 0L;
        this.lastModified = lastModified;
        this.permissionStatus = permissionStatus;
        this.blobMaterialization = blobMaterialization;
    }

    public boolean isDir() {
        return this.isDir;
    }

    public String getKey() {
        return this.key;
    }

    public long getLength() {
        return this.length;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public PermissionStatus getPermissionStatus() {
        return this.permissionStatus;
    }

    public BlobMaterialization getBlobMaterialization() {
        return this.blobMaterialization;
    }

    public String toString() {
        return "FileMetadata[" + this.key + ", " + this.length + ", " + this.lastModified + ", " + this.permissionStatus + "]";
    }
}

