/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.shortcircuit;

import com.facebook.presto.hadoop.$internal.com.google.common.annotations.VisibleForTesting;
import com.facebook.presto.hadoop.$internal.com.google.common.base.Preconditions;
import com.facebook.presto.hadoop.$internal.com.google.common.cache.Cache;
import com.facebook.presto.hadoop.$internal.com.google.common.cache.CacheBuilder;
import com.facebook.presto.hadoop.$internal.org.apache.commons.io.IOUtils;
import com.facebook.presto.hadoop.$internal.org.apache.commons.logging.Log;
import com.facebook.presto.hadoop.$internal.org.apache.commons.logging.LogFactory;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.net.unix.DomainSocket;
import org.apache.hadoop.util.PerformanceAdvisory;

public class DomainSocketFactory {
    private static final Log LOG = LogFactory.getLog(DomainSocketFactory.class);
    final Cache<String, PathState> pathMap = CacheBuilder.newBuilder().expireAfterWrite(10L, TimeUnit.MINUTES).build();

    public DomainSocketFactory(DFSClient.Conf conf) {
        String feature = conf.isShortCircuitLocalReads() && !conf.isUseLegacyBlockReaderLocal() ? "The short-circuit local reads feature" : (conf.isDomainSocketDataTraffic() ? "UNIX domain socket data traffic" : null);
        if (feature == null) {
            PerformanceAdvisory.LOG.debug("Both short-circuit local reads and UNIX domain socket are disabled.");
        } else {
            if (conf.getDomainSocketPath().isEmpty()) {
                throw new HadoopIllegalArgumentException(feature + " is enabled but " + "dfs.domain.socket.path" + " is not set.");
            }
            if (DomainSocket.getLoadingFailureReason() != null) {
                LOG.warn(feature + " cannot be used because " + DomainSocket.getLoadingFailureReason());
            } else {
                LOG.debug(feature + " is enabled.");
            }
        }
    }

    public PathInfo getPathInfo(InetSocketAddress addr, DFSClient.Conf conf) {
        if (conf.getDomainSocketPath().isEmpty()) {
            return PathInfo.NOT_CONFIGURED;
        }
        if (!(conf.isDomainSocketDataTraffic() || conf.isShortCircuitLocalReads() && !conf.isUseLegacyBlockReaderLocal())) {
            return PathInfo.NOT_CONFIGURED;
        }
        if (DomainSocket.getLoadingFailureReason() != null) {
            return PathInfo.NOT_CONFIGURED;
        }
        if (!DFSClient.isLocalAddress(addr)) {
            return PathInfo.NOT_CONFIGURED;
        }
        String escapedPath = DomainSocket.getEffectivePath(conf.getDomainSocketPath(), addr.getPort());
        PathState status = this.pathMap.getIfPresent(escapedPath);
        if (status == null) {
            return new PathInfo(escapedPath, PathState.VALID);
        }
        return new PathInfo(escapedPath, status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DomainSocket createSocket(PathInfo info, int socketTimeout) {
        Preconditions.checkArgument(info.getPathState() != PathState.UNUSABLE);
        boolean success = false;
        DomainSocket sock = null;
        try {
            sock = DomainSocket.connect(info.getPath());
            sock.setAttribute(4, socketTimeout);
            success = true;
        }
        catch (IOException e) {
            LOG.warn("error creating DomainSocket", e);
        }
        finally {
            if (!success) {
                if (sock != null) {
                    IOUtils.closeQuietly(sock);
                }
                this.pathMap.put(info.getPath(), PathState.UNUSABLE);
                sock = null;
            }
        }
        return sock;
    }

    public void disableShortCircuitForPath(String path) {
        this.pathMap.put(path, PathState.SHORT_CIRCUIT_DISABLED);
    }

    public void disableDomainSocketPath(String path) {
        this.pathMap.put(path, PathState.UNUSABLE);
    }

    @VisibleForTesting
    public void clearPathMap() {
        this.pathMap.invalidateAll();
    }

    public static class PathInfo {
        private static final PathInfo NOT_CONFIGURED = new PathInfo("", PathState.UNUSABLE);
        private final String path;
        private final PathState state;

        PathInfo(String path, PathState state) {
            this.path = path;
            this.state = state;
        }

        public String getPath() {
            return this.path;
        }

        public PathState getPathState() {
            return this.state;
        }

        public String toString() {
            return "PathInfo{path=" + this.path + ", state=" + (Object)((Object)this.state) + "}";
        }
    }

    public static enum PathState {
        UNUSABLE(false, false),
        SHORT_CIRCUIT_DISABLED(true, false),
        VALID(true, true);

        private final boolean usableForDataTransfer;
        private final boolean usableForShortCircuit;

        private PathState(boolean usableForDataTransfer, boolean usableForShortCircuit) {
            this.usableForDataTransfer = usableForDataTransfer;
            this.usableForShortCircuit = usableForShortCircuit;
        }

        public boolean getUsableForDataTransfer() {
            return this.usableForDataTransfer;
        }

        public boolean getUsableForShortCircuit() {
            return this.usableForShortCircuit;
        }
    }
}

