/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2;

import com.facebook.presto.hadoop.$internal.com.google.common.base.Objects;
import com.facebook.presto.hadoop.$internal.com.google.common.base.Preconditions;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.metrics2.MetricType;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsVisitor;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public abstract class AbstractMetric
implements MetricsInfo {
    private final MetricsInfo info;

    protected AbstractMetric(MetricsInfo info) {
        this.info = Preconditions.checkNotNull(info, "metric info");
    }

    @Override
    public String name() {
        return this.info.name();
    }

    @Override
    public String description() {
        return this.info.description();
    }

    protected MetricsInfo info() {
        return this.info;
    }

    public abstract Number value();

    public abstract MetricType type();

    public abstract void visit(MetricsVisitor var1);

    public boolean equals(Object obj) {
        if (obj instanceof AbstractMetric) {
            AbstractMetric other = (AbstractMetric)obj;
            return Objects.equal(this.info, other.info()) && Objects.equal(this.value(), other.value());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.info, this.value());
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("info", (Object)this.info).add("value", (Object)this.value()).toString();
    }
}

