/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.localfile;

import com.facebook.presto.localfile.LocalFileConnector;
import com.facebook.presto.localfile.LocalFileHandleResolver;
import com.facebook.presto.localfile.LocalFileModule;
import com.facebook.presto.spi.ConnectorHandleResolver;
import com.facebook.presto.spi.NodeManager;
import com.facebook.presto.spi.connector.Connector;
import com.facebook.presto.spi.connector.ConnectorContext;
import com.facebook.presto.spi.connector.ConnectorFactory;
import com.google.common.base.Throwables;
import com.google.inject.Injector;
import com.google.inject.Module;
import io.airlift.bootstrap.Bootstrap;
import java.util.Map;
import java.util.Objects;

public class LocalFileConnectorFactory
implements ConnectorFactory {
    public String getName() {
        return "localfile";
    }

    public ConnectorHandleResolver getHandleResolver() {
        return new LocalFileHandleResolver();
    }

    public Connector create(String connectorId, Map<String, String> config, ConnectorContext context) {
        Objects.requireNonNull(config, "config is null");
        try {
            Bootstrap app = new Bootstrap(new Module[]{binder -> binder.bind(NodeManager.class).toInstance((Object)context.getNodeManager()), new LocalFileModule(connectorId)});
            Injector injector = app.strictConfig().doNotInitializeLogging().setRequiredConfigurationProperties(config).initialize();
            return (Connector)injector.getInstance(LocalFileConnector.class);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

