/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.localfile;

import com.facebook.presto.localfile.LocalFileColumnHandle;
import com.facebook.presto.localfile.LocalFileRecordSet;
import com.facebook.presto.localfile.LocalFileSplit;
import com.facebook.presto.localfile.LocalFileTables;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.RecordSet;
import com.facebook.presto.spi.connector.ConnectorRecordSetProvider;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;

public class LocalFileRecordSetProvider
implements ConnectorRecordSetProvider {
    private final LocalFileTables localFileTables;

    @Inject
    public LocalFileRecordSetProvider(LocalFileTables localFileTables) {
        this.localFileTables = Objects.requireNonNull(localFileTables, "localFileTables is null");
    }

    public RecordSet getRecordSet(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorSplit split, List<? extends ColumnHandle> columns) {
        Objects.requireNonNull(split, "split is null");
        LocalFileSplit localFileSplit = (LocalFileSplit)split;
        ImmutableList.Builder handles = ImmutableList.builder();
        for (ColumnHandle columnHandle : columns) {
            handles.add((Object)((LocalFileColumnHandle)columnHandle));
        }
        return new LocalFileRecordSet(this.localFileTables, localFileSplit, (List<LocalFileColumnHandle>)handles.build());
    }
}

