/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.localfile;

import com.facebook.presto.localfile.DataLocation;
import com.facebook.presto.localfile.LocalFileConfig;
import com.facebook.presto.localfile.LocalFileMetadata;
import com.facebook.presto.localfile.LocalFileTableHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.TimestampType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;

public class LocalFileTables {
    private final Map<SchemaTableName, DataLocation> tableDataLocations;
    private final Map<SchemaTableName, LocalFileTableHandle> tables;
    private final Map<SchemaTableName, List<ColumnMetadata>> tableColumns;
    private final LoadingCache<SchemaTableName, List<File>> cachedFiles;

    @Inject
    public LocalFileTables(LocalFileConfig config) {
        ImmutableMap.Builder dataLocationBuilder = ImmutableMap.builder();
        ImmutableMap.Builder tablesBuilder = ImmutableMap.builder();
        ImmutableMap.Builder tableColumnsBuilder = ImmutableMap.builder();
        String httpRequestLogLocation = config.getHttpRequestLogLocation();
        if (httpRequestLogLocation != null) {
            Optional<String> pattern = Optional.empty();
            if (config.getHttpRequestLogFileNamePattern() != null) {
                pattern = Optional.of(config.getHttpRequestLogFileNamePattern());
            }
            SchemaTableName table = HttpRequestLogTable.getSchemaTableName();
            DataLocation dataLocation = new DataLocation(httpRequestLogLocation, pattern);
            LocalFileTableHandle tableHandle = new LocalFileTableHandle(table, HttpRequestLogTable.getTimestampColumn(), HttpRequestLogTable.getServerAddressColumn());
            tablesBuilder.put((Object)table, (Object)tableHandle);
            tableColumnsBuilder.put((Object)table, HttpRequestLogTable.getColumns());
            dataLocationBuilder.put((Object)table, (Object)dataLocation);
        }
        this.tables = tablesBuilder.build();
        this.tableColumns = tableColumnsBuilder.build();
        this.tableDataLocations = dataLocationBuilder.build();
        this.cachedFiles = CacheBuilder.newBuilder().expireAfterWrite(10L, TimeUnit.SECONDS).build(CacheLoader.from(key -> this.tableDataLocations.get(key).files()));
    }

    public LocalFileTableHandle getTable(SchemaTableName tableName) {
        return this.tables.get(tableName);
    }

    public List<SchemaTableName> getTables() {
        return ImmutableList.copyOf(this.tables.keySet());
    }

    public List<ColumnMetadata> getColumns(LocalFileTableHandle tableHandle) {
        Preconditions.checkArgument((boolean)this.tableColumns.containsKey(tableHandle.getSchemaTableName()), (String)"Table %s not registered", (Object)tableHandle.getSchemaTableName());
        return this.tableColumns.get(tableHandle.getSchemaTableName());
    }

    public List<File> getFiles(SchemaTableName table) {
        try {
            return (List)this.cachedFiles.getUnchecked((Object)table);
        }
        catch (UncheckedExecutionException e) {
            Throwables.throwIfInstanceOf((Throwable)e.getCause(), PrestoException.class);
            throw e;
        }
    }

    public static class HttpRequestLogTable {
        private static final List<ColumnMetadata> COLUMNS = ImmutableList.of((Object)LocalFileMetadata.SERVER_ADDRESS_COLUMN, (Object)new ColumnMetadata("timestamp", (Type)TimestampType.TIMESTAMP), (Object)new ColumnMetadata("client_address", (Type)VarcharType.createUnboundedVarcharType()), (Object)new ColumnMetadata("method", (Type)VarcharType.createUnboundedVarcharType()), (Object)new ColumnMetadata("request_uri", (Type)VarcharType.createUnboundedVarcharType()), (Object)new ColumnMetadata("user", (Type)VarcharType.createUnboundedVarcharType()), (Object)new ColumnMetadata("agent", (Type)VarcharType.createUnboundedVarcharType()), (Object)new ColumnMetadata("response_code", (Type)BigintType.BIGINT), (Object)new ColumnMetadata("request_size", (Type)BigintType.BIGINT), (Object)new ColumnMetadata("response_size", (Type)BigintType.BIGINT), (Object)new ColumnMetadata("time_to_last_byte", (Type)BigintType.BIGINT), (Object)new ColumnMetadata("trace_token", (Type)VarcharType.createUnboundedVarcharType()), (Object[])new ColumnMetadata[0]);
        private static final String TABLE_NAME = "http_request_log";

        public static List<ColumnMetadata> getColumns() {
            return COLUMNS;
        }

        public static SchemaTableName getSchemaTableName() {
            return new SchemaTableName("logs", TABLE_NAME);
        }

        public static OptionalInt getTimestampColumn() {
            return OptionalInt.of(0);
        }

        public static OptionalInt getServerAddressColumn() {
            return OptionalInt.of(-1);
        }
    }
}

