/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.localfile;

import com.facebook.presto.localfile.LocalFileColumnHandle;
import com.facebook.presto.localfile.LocalFileTableHandle;
import com.facebook.presto.localfile.LocalFileTableLayoutHandle;
import com.facebook.presto.localfile.LocalFileTables;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.ConnectorTableLayout;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.ConnectorTableLayoutResult;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.ConnectorViewDefinition;
import com.facebook.presto.spi.Constraint;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.SchemaTablePrefix;
import com.facebook.presto.spi.connector.ConnectorMetadata;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;

public class LocalFileMetadata
implements ConnectorMetadata {
    public static final String PRESTO_LOGS_SCHEMA = "logs";
    public static final ColumnMetadata SERVER_ADDRESS_COLUMN = new ColumnMetadata("server_address", (Type)VarcharType.createUnboundedVarcharType());
    private static final List<String> SCHEMA_NAMES = ImmutableList.of((Object)"logs");
    private final LocalFileTables localFileTables;

    @Inject
    public LocalFileMetadata(LocalFileTables localFileTables) {
        this.localFileTables = Objects.requireNonNull(localFileTables, "localFileTables is null");
    }

    public List<String> listSchemaNames(ConnectorSession session) {
        return SCHEMA_NAMES;
    }

    public ConnectorTableHandle getTableHandle(ConnectorSession session, SchemaTableName tableName) {
        Objects.requireNonNull(tableName, "tableName is null");
        return this.localFileTables.getTable(tableName);
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle table) {
        LocalFileTableHandle tableHandle = (LocalFileTableHandle)table;
        return new ConnectorTableMetadata(tableHandle.getSchemaTableName(), this.localFileTables.getColumns(tableHandle));
    }

    public List<SchemaTableName> listTables(ConnectorSession session, String schemaNameOrNull) {
        return this.localFileTables.getTables();
    }

    public List<ConnectorTableLayoutResult> getTableLayouts(ConnectorSession session, ConnectorTableHandle table, Constraint<ColumnHandle> constraint, Optional<Set<ColumnHandle>> desiredColumns) {
        LocalFileTableHandle tableHandle = (LocalFileTableHandle)table;
        ConnectorTableLayout layout = new ConnectorTableLayout((ConnectorTableLayoutHandle)new LocalFileTableLayoutHandle(tableHandle, (TupleDomain<ColumnHandle>)constraint.getSummary()));
        return ImmutableList.of((Object)new ConnectorTableLayoutResult(layout, constraint.getSummary()));
    }

    public ConnectorTableLayout getTableLayout(ConnectorSession session, ConnectorTableLayoutHandle handle) {
        LocalFileTableLayoutHandle layout = (LocalFileTableLayoutHandle)handle;
        return new ConnectorTableLayout((ConnectorTableLayoutHandle)layout);
    }

    public Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, ConnectorTableHandle table) {
        LocalFileTableHandle tableHandle = (LocalFileTableHandle)table;
        return this.getColumnHandles(tableHandle);
    }

    private Map<String, ColumnHandle> getColumnHandles(LocalFileTableHandle tableHandle) {
        ImmutableMap.Builder columnHandles = ImmutableMap.builder();
        int index = 0;
        for (ColumnMetadata column : this.localFileTables.getColumns(tableHandle)) {
            int ordinalPosition = column.getName().equals("server_address") ? -1 : index++;
            columnHandles.put((Object)column.getName(), (Object)new LocalFileColumnHandle(column.getName(), column.getType(), ordinalPosition));
        }
        return columnHandles.build();
    }

    public ColumnMetadata getColumnMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
        return ((LocalFileColumnHandle)columnHandle).toColumnMetadata();
    }

    public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
        Objects.requireNonNull(prefix, "prefix is null");
        ImmutableMap.Builder columns = ImmutableMap.builder();
        for (SchemaTableName tableName : this.listTables(session, prefix)) {
            LocalFileTableHandle tableHandle = this.localFileTables.getTable(tableName);
            if (tableHandle == null) continue;
            columns.put((Object)tableName, this.localFileTables.getColumns(tableHandle));
        }
        return columns.build();
    }

    public List<SchemaTableName> listViews(ConnectorSession session, String schemaNameOrNull) {
        return Collections.emptyList();
    }

    public Map<SchemaTableName, ConnectorViewDefinition> getViews(ConnectorSession session, SchemaTablePrefix prefix) {
        return Collections.emptyMap();
    }

    private List<SchemaTableName> listTables(ConnectorSession session, SchemaTablePrefix prefix) {
        if (prefix.getSchemaName() == null) {
            return this.listTables(session, prefix.getSchemaName());
        }
        return ImmutableList.of((Object)new SchemaTableName(prefix.getSchemaName(), prefix.getTableName()));
    }
}

