/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.localfile;

import com.facebook.presto.localfile.LocalFileErrorCode;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

final class DataLocation {
    private final File location;
    private final Optional<String> pattern;

    @JsonCreator
    public DataLocation(@JsonProperty(value="location") String location, @JsonProperty(value="pattern") Optional<String> pattern) {
        Objects.requireNonNull(location, "location is null");
        Objects.requireNonNull(pattern, "pattern is null");
        File file = new File(location);
        if (!file.exists() && pattern.isPresent()) {
            file.mkdirs();
        }
        Preconditions.checkArgument((boolean)file.exists(), (Object)"location does not exist");
        if (pattern.isPresent() && !file.isDirectory()) {
            throw new IllegalArgumentException("pattern may be specified only if location is a directory");
        }
        this.location = file;
        this.pattern = !pattern.isPresent() && file.isDirectory() ? Optional.of("*") : pattern;
    }

    @JsonProperty
    public File getLocation() {
        return this.location;
    }

    @JsonProperty
    public Optional<String> getPattern() {
        return this.pattern;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<File> files() {
        Preconditions.checkState((boolean)this.location.exists(), (String)"location %s doesn't exist", (Object)this.location);
        if (!this.pattern.isPresent()) {
            return ImmutableList.of((Object)this.location);
        }
        Preconditions.checkState((boolean)this.location.isDirectory(), (String)"location %s is not a directory", (Object)this.location);
        try (DirectoryStream<Path> paths = Files.newDirectoryStream(this.location.toPath(), this.pattern.get());){
            ImmutableList.Builder builder = ImmutableList.builder();
            for (Path path : paths) {
                builder.add((Object)path.toFile());
            }
            ImmutableList files = builder.build();
            if (files.isEmpty()) {
                throw new PrestoException((ErrorCodeSupplier)LocalFileErrorCode.LOCAL_FILE_NO_FILES, "No matching files found in directory: " + this.location);
            }
            List<File> list = files.stream().sorted((o1, o2) -> Long.compare(o2.lastModified(), o1.lastModified())).collect(Collectors.toList());
            return list;
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)LocalFileErrorCode.LOCAL_FILE_FILESYSTEM_ERROR, "Error listing files in directory: " + this.location, (Throwable)e);
        }
    }
}

