/*
 * Decompiled with CFR 0.152.
 */
package org.weakref.jmx;

import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.weakref.jmx.ObjectNames;
import org.weakref.jmx.internal.guava.base.Preconditions;

public class ObjectNameBuilder {
    private static final Pattern BAD_PACKAGENAME_PATTERN = Pattern.compile("[:?*]");
    private final StringBuilder objectName;
    private final Set<String> properties = new HashSet<String>();

    public ObjectNameBuilder(String packageName) {
        Preconditions.checkNotNull(packageName, "packageName is null");
        Preconditions.checkArgument(!BAD_PACKAGENAME_PATTERN.matcher(packageName).find(), "packageName is invalid");
        this.objectName = new StringBuilder(packageName);
    }

    public ObjectNameBuilder withProperty(String name, String value) {
        if (this.properties.isEmpty()) {
            this.objectName.append(":");
        } else {
            this.objectName.append(",");
        }
        Preconditions.checkArgument(this.properties.add(name), "Duplicate property name " + name);
        this.objectName.append(name).append('=').append(ObjectNames.quoteValueIfNecessary(value));
        return this;
    }

    public String build() {
        return this.objectName.toString();
    }
}

