/*
 * Decompiled with CFR 0.152.
 */
package org.weakref.jmx.guice;

import com.google.inject.multibindings.Multibinder;
import java.util.Map;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.weakref.jmx.ObjectNames;
import org.weakref.jmx.guice.MapMapping;
import org.weakref.jmx.guice.MapNamingFunction;
import org.weakref.jmx.guice.MapObjectNameFunction;
import org.weakref.jmx.guice.NamingFunction;
import org.weakref.jmx.guice.ObjectNameFunction;
import org.weakref.jmx.internal.guava.base.Throwables;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapExportBinder<K, V> {
    protected final Multibinder<MapMapping<?, ?>> binder;
    protected final Class<K> keyClass;
    private final Class<V> valueClass;

    MapExportBinder(Multibinder<MapMapping<?, ?>> binder, Class<K> keyClass, Class<V> valueClass) {
        this.binder = binder;
        this.keyClass = keyClass;
        this.valueClass = valueClass;
    }

    public void withGeneratedName(final NamingFunction<V> valueNamingFunction) {
        ObjectNameFunction objectNameFunction = new ObjectNameFunction<Map.Entry<K, V>>(){

            @Override
            public ObjectName name(Map.Entry<K, V> entry) {
                try {
                    String itemName = valueNamingFunction.name(entry.getValue());
                    return new ObjectName(ObjectNames.generatedNameOf(MapExportBinder.this.valueClass, itemName));
                }
                catch (MalformedObjectNameException e) {
                    throw Throwables.propagate(e);
                }
            }
        };
        this.binder.addBinding().toInstance(new MapMapping<K, V>(this.keyClass, this.valueClass, objectNameFunction));
    }

    public void withGeneratedName(final ObjectNameFunction<V> valueNamingFunction) {
        ObjectNameFunction objectNameFunction = new ObjectNameFunction<Map.Entry<K, V>>(){

            @Override
            public ObjectName name(Map.Entry<K, V> entry) {
                return valueNamingFunction.name(entry.getValue());
            }
        };
        this.binder.addBinding().toInstance(new MapMapping<K, V>(this.keyClass, this.valueClass, objectNameFunction));
    }

    public void withGeneratedName(final MapNamingFunction<K, V> valueNamingFunction) {
        ObjectNameFunction objectNameFunction = new ObjectNameFunction<Map.Entry<K, V>>(){

            @Override
            public ObjectName name(Map.Entry<K, V> entry) {
                try {
                    String itemName = valueNamingFunction.name(entry.getKey(), entry.getValue());
                    return new ObjectName(ObjectNames.generatedNameOf(MapExportBinder.this.valueClass, itemName));
                }
                catch (MalformedObjectNameException e) {
                    throw Throwables.propagate(e);
                }
            }
        };
        this.binder.addBinding().toInstance(new MapMapping<K, V>(this.keyClass, this.valueClass, objectNameFunction));
    }

    public void withGeneratedName(final MapObjectNameFunction<K, V> valueNamingFunction) {
        ObjectNameFunction objectNameFunction = new ObjectNameFunction<Map.Entry<K, V>>(){

            @Override
            public ObjectName name(Map.Entry<K, V> entry) {
                return valueNamingFunction.name(entry.getKey(), entry.getValue());
            }
        };
        this.binder.addBinding().toInstance(new MapMapping<K, V>(this.keyClass, this.valueClass, objectNameFunction));
    }
}

