/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.jdbc;

import com.facebook.presto.plugin.jdbc.JdbcHandleResolver;
import com.facebook.presto.plugin.jdbc.JdbcMetadata;
import com.facebook.presto.plugin.jdbc.JdbcRecordSetProvider;
import com.facebook.presto.plugin.jdbc.JdbcRecordSinkProvider;
import com.facebook.presto.plugin.jdbc.JdbcSplitManager;
import com.facebook.presto.spi.Connector;
import com.facebook.presto.spi.ConnectorHandleResolver;
import com.facebook.presto.spi.ConnectorMetadata;
import com.facebook.presto.spi.ConnectorRecordSetProvider;
import com.facebook.presto.spi.ConnectorRecordSinkProvider;
import com.facebook.presto.spi.ConnectorSplitManager;
import com.google.common.base.Preconditions;
import io.airlift.bootstrap.LifeCycleManager;
import io.airlift.log.Logger;
import javax.inject.Inject;

public class JdbcConnector
implements Connector {
    private static final Logger log = Logger.get(JdbcConnector.class);
    private final LifeCycleManager lifeCycleManager;
    private final JdbcMetadata jdbcMetadata;
    private final JdbcSplitManager jdbcSplitManager;
    private final JdbcRecordSetProvider jdbcRecordSetProvider;
    private final JdbcHandleResolver jdbcHandleResolver;
    private final JdbcRecordSinkProvider jdbcRecordSinkProvider;

    @Inject
    public JdbcConnector(LifeCycleManager lifeCycleManager, JdbcMetadata jdbcMetadata, JdbcSplitManager jdbcSplitManager, JdbcRecordSetProvider jdbcRecordSetProvider, JdbcHandleResolver jdbcHandleResolver, JdbcRecordSinkProvider jdbcRecordSinkProvider) {
        this.lifeCycleManager = (LifeCycleManager)Preconditions.checkNotNull((Object)lifeCycleManager, (Object)"lifeCycleManager is null");
        this.jdbcMetadata = (JdbcMetadata)Preconditions.checkNotNull((Object)jdbcMetadata, (Object)"jdbcMetadata is null");
        this.jdbcSplitManager = (JdbcSplitManager)Preconditions.checkNotNull((Object)jdbcSplitManager, (Object)"jdbcSplitManager is null");
        this.jdbcRecordSetProvider = (JdbcRecordSetProvider)Preconditions.checkNotNull((Object)jdbcRecordSetProvider, (Object)"jdbcRecordSetProvider is null");
        this.jdbcHandleResolver = (JdbcHandleResolver)Preconditions.checkNotNull((Object)jdbcHandleResolver, (Object)"jdbcHandleResolver is null");
        this.jdbcRecordSinkProvider = (JdbcRecordSinkProvider)Preconditions.checkNotNull((Object)jdbcRecordSinkProvider, (Object)"jdbcRecordSinkProvider is null");
    }

    public ConnectorMetadata getMetadata() {
        return this.jdbcMetadata;
    }

    public ConnectorSplitManager getSplitManager() {
        return this.jdbcSplitManager;
    }

    public ConnectorRecordSetProvider getRecordSetProvider() {
        return this.jdbcRecordSetProvider;
    }

    public ConnectorHandleResolver getHandleResolver() {
        return this.jdbcHandleResolver;
    }

    public ConnectorRecordSinkProvider getRecordSinkProvider() {
        return this.jdbcRecordSinkProvider;
    }

    public final void shutdown() {
        try {
            this.lifeCycleManager.stop();
        }
        catch (Exception e) {
            log.error((Throwable)e, "Error shutting down connector");
        }
    }
}

