/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.postgresql;

import com.facebook.presto.plugin.postgresql.PostgreSqlQueryRunner;
import com.facebook.presto.tests.AbstractTestQueries;
import io.airlift.testing.Closeables;
import io.airlift.testing.postgresql.TestingPostgreSqlServer;
import io.airlift.tpch.TpchTable;
import java.io.Closeable;
import java.io.IOException;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

@Test
public class TestPostgreSqlDistributedQueries
extends AbstractTestQueries {
    private final TestingPostgreSqlServer postgreSqlServer;

    public TestPostgreSqlDistributedQueries() throws Exception {
        this(new TestingPostgreSqlServer("testuser", "tpch"));
    }

    public TestPostgreSqlDistributedQueries(TestingPostgreSqlServer postgreSqlServer) throws Exception {
        super(PostgreSqlQueryRunner.createPostgreSqlQueryRunner(postgreSqlServer, TpchTable.getTables()));
        this.postgreSqlServer = postgreSqlServer;
    }

    @AfterClass(alwaysRun=true)
    public final void destroy() throws IOException {
        Closeables.closeAllRuntimeException((Closeable[])new Closeable[]{this.postgreSqlServer});
    }

    @Test
    public void testDropTable() throws Exception {
        this.assertQueryTrue("CREATE TABLE test_drop AS SELECT 123 x");
        Assert.assertTrue((boolean)this.queryRunner.tableExists(this.getSession(), "test_drop"));
        this.assertQueryTrue("DROP TABLE test_drop");
        Assert.assertFalse((boolean)this.queryRunner.tableExists(this.getSession(), "test_drop"));
    }
}

