/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.configuration;

import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;

public class ConfigurationLoader {
    public Map<String, String> loadProperties() throws IOException {
        TreeMap result = Maps.newTreeMap();
        String configFile = System.getProperty("config");
        if (configFile != null) {
            result.putAll(this.loadPropertiesFrom(configFile));
        }
        result.putAll(this.getSystemProperties());
        return ImmutableSortedMap.copyOf((Map)result);
    }

    public Map<String, String> loadPropertiesFrom(String path) throws IOException {
        Properties properties = new Properties();
        try (FileReader reader = new FileReader(new File(path));){
            properties.load(reader);
        }
        return Maps.fromProperties((Properties)properties);
    }

    public Map<String, String> getSystemProperties() {
        return Maps.fromProperties((Properties)System.getProperties());
    }
}

